# Zero
  Copyright (C) Y-Kuze(久世雄一)

-----------------------

* はじめに  
    **Pyxis**という素晴らしいファイラーがあります。  
    このファイラーを愛用しています。  
    **Zero**は、作成すべきか否か悩んだのですが、**Pyxis**が今後機能UPするのを待つより
    自分の必要なものは自分で作るしかないという結論に至り、開発を開始しました。  
    したがって、**Pyxis**に似たようなファイラーになっています。  
    これが私にとって使いやすい形なのです。

* 動作環境  
    Windows10、11 で動作いたします。  
    (Windows 10、11でしか動作確認していません。)

* インストール方法  
    インストーラーは付属しておりません。  
    zipファイルを適当なフォルダーに展開していただくだけで動作いたします。
    zipファイルは展開前にプロパティのセキュリティを許可するに変更してください。
    （Win10以降、セキュリティ強化によりダウンロードしたzipファイルにこの制限が付きました）  
    http://kuze.tea-nifty.com/blog/cat24368066/index.html  
    ただし、Program Files 配下は、ソフトに多くの制限がかかるため現在対応が不十分です。  
    C:\Zeroなどのフォルダーを作成して展開していただくのがよいかと思います。

* アンインストール方法  
    フォルダーごと消してください。  
    32bit(Free)版は、レジストリーは一切使用していないためきれいサッパリ消せます。  
    64bit版は、ライセンスキーの登録を解除することでレジストリーの情報を削除できます。

* キー割り当て  
    
    |キー       |名称         |機能                              |対応窓[^2]|
    |-----------|-------------|----------------------------------|----------|
    | A         | Attr        |属性変更                          | F L _ R  |
    | B         | clipBoard   |ファイル名をクリップボードへ      | F L P R  |
    | C         | Copy        |コピー                            | F L _ _  |
    | D         | Delete      |削除                              | F L _ R  |
    | E         | Edit        |編集                              | F L P _  |
    | F         | Find        |ファイル検索                      | F _ _ R  |
    | G         | ---         |                                  |          |
    | H         | cHdir       |指定フォルダー(ディレクトリ)へ    | F _ _ R  |
    | I         | Incsearch   |インクリメンタルサーチ[^1]        | F L P R  |
    | J         | Jump        |ジャンプ                          | F _ _ R  |
    | K         | mKdir       |フォルダー(ディレクトリ)作成      | F _ _ R  |
    | L         | Logdisk     |ドライブ変更                      | F _ _ R  |
    | M         | Move        |ファイル移動                      | F L _ _  |
    | N         | reName      |名前変更                          | F L _ R  |
    | O         | loadpos     |窓位置の復帰                      | F _ _ _  |
    | P         | Pack        |圧縮 (拡張子で圧縮形式を決定)     | F _ _ _  |
    | Q         | Quitmenu    |終了メニュー                      | F _ _ _  |
    | R         | Run         |実行                              | F L _ _  |
    | S         | Sort        |並び替え                          | F L P R  |
    | T         | ---         |                                  |          |
    | U         | Unpack      |展開 (拡張子で圧縮形式を決定)     | F _ P _  |
    | V         | View        |閲覧                              | F L P _  |
    | W         | Wwin        |2画面表示                         | F _ _ _  |
    | X         | eXec        |入力コマンド実行                  | F L _ _  |
    | Y         | wildcard    |ワイルド(Yild)カード              | F L P R  |
    | Z         | launcher    |ランチャー実行                    | F L P _  |
    | @         | Incsearch   |インクリメンタルサーチ [^1]       | F L P R  |
    | \         | root        |ルートフォルダーへ                | F _ P R  |
    | F1        | keyhelp     |キーヘルプ                        | F _ P _  |
    | F2        | nextzero    |次のZeroに切替                    | F L P R  |
    | F3        | zerolist    |Zero一覧                          | F L P R  |
    | F5        | sortname    |名前順                            | F L P R  |
    | F6        | sortdate    |日付順                            | F L P R  |
    | F7        | sortsize    |サイズ順                          | F L P R  |
    | F8        | hiddensys   |隠し・システムファイル表示        | F L P R  |
    | F9        | vertical    |縦に並べる                        | F _ _ _  |
    | F10       | horizontal  |横に並べる                        | F _ _ _  |
    | F11       | tile        |並べて表示                        | F _ _ _  |
    | F12       | cascade     |重ねて表示                        | F _ _ _  |
    | Left      | left        |左に移動                          | F _ P R  |
    | Right     | right       |右に移動                          | F _ P R  |
    | Up        | up          |上に移動                          | F L P R  |
    | Down      | down        |下に移動                          | F L P R  |
    | Space     | mark        |マーク                            | F L P R  |
    | BkSp      | parentdir   |親フォルダーへ                    | F _ P _  |
    | PgUp      | prevpage    |前の画面に移動                    | F L P R  |
    | PgDn      | nextpage    |次の画面に移動                    | F L P R  |
    | Tab       | togglezero  |トグルでZeroを切替                | F L P R  |
    | Home      | allfilemark |全ファイルマーク                  | F L P _  |
    | Esc       | quit        |終了                              | F _ _ _  |
    | 0-9       | number jump |0: Z, 1-9: A-Iドライブに変更 [^3] | F _ _ R  |
    |application| contextmenu |右クリック(コンテキスト)メニュー  | F L _ _  |
    |           | sortnamef   |名前順:前向き                     | F L P R  |
    |           | sortnameb   |名前順:後ろ向き                   | F L P R  |
    |           | sortdatef   |日付順:前向き                     | F L P R  |
    |           | sortdateb   |日付順:後ろ向き                   | F L P R  |
    |           | sortsizef   |サイズ順:前向き                   | F L P R  |
    |           | sortsizeb   |サイズ順:後ろ向き                 | F L P R  |
    |           | noaction    |何もしない                        | F L P R  |
    |           | goshortcut  |ショートカットのリンク先に移動    | F _ _ _  |
    |           | sizeinfo    |サイズ情報表示                    | F L _ R  |
    |           | property    |プロパティ                        | F L _ R  |

    [^1]: TABキーで次候補に移動  
    [^2]: F-FileView(ファイル窓), L-ListView(リスト窓), P-PackView(圧縮窓), R-RefView(参照窓)  
    [^3]: キーカスタマイズできません  

    |キー       |名称            |機能                                        |対応窓   |
    |-----------|----------------|--------------------------------------------|---------|
    | Shift+B   | clipBoardlink  |ハイパーリンクをクリップボードへ            | F L _ R |
    | Shift+C   | refCopy        |参照してコピー                              | F _ _ _ |
    | Shift+J   | oppJump        |ジャンプ(2画面反対側)                       | F _ _ _ |
    | Shift+M   | refMove        |参照して移動                                | F _ _ _ |
    | Shift+N   | lowercaseName  |小文字に変更                                | F L _ R |
    | Shift+O   | savepos        |窓位置の保存                                | F _ _ _ |
    | Shift+V   | Volume         |ボリュームラベルの変更                      | F _ _ _ |
    | Shift+0   | MNumJmpList    |メモリナンバージャンプリスト表示            | F _ _ R |
    | Shift+1～9| MNumJmp1～9    |メモリナンバージャンプで指定フォルダーへ    | F _ _ R |
    | Shift+Home| revallfilemark |全ファイルマーク反転                        | F L P _ |
    | Shift+F2  | prevzero       |前のZeroに切替                              | F L P R |
    | Shift+F10 | contextmenu    |右クリック(コンテキスト)メニュー            | F L _ _ |

    |キー       |名称            |機能                                        |対応窓   |
    |-----------|----------------|--------------------------------------------|---------|
    | Ctrl+A    | Allmark        |全マーク                                    | F L P _ |
    | Ctrl+B    | clipBoardfull  |フルパスをクリップボードへ                  | F L _ R |
    | Ctrl+C    | Copy_explorer  |コピー - エクスプローラー                   | F _ _ R |
    | Ctrl+E    | Editnewfile    |新規ファイル編集                            | F _ _ _ |
    | Ctrl+H    | addHistory     |カレントフォルダーを履歴に追加              | F _ _ R |
    | Ctrl+K    | wildmark       |ワイルドカードでマーク                      | F L P _ |
    | Ctrl+L    | network        |ネットワーク接続                            | F _ _ R |
    | Ctrl+N    | uppercaseName  |大文字に変更                                | F L _ R |
    | Ctrl+O    | eject          |取り出し                                    | F _ _ R |
    | Ctrl+P    | Packcmd        |圧縮コマンド (コマンド編集可)               | F _ _ _ |
    | Ctrl+R    | Refresh        |画面リフレッシュ                            | F _ _ R |
    | Ctrl+T    | Timestamp      |ファイルのタイムスタンプ変更                | F L _ R |
    | Ctrl+U    | Unpackcmd      |展開コマンド (コマンド編集可)               | F _ P _ |
    | Ctrl+V    | paste_explorer |貼り付け - エクスプローラー                 | F _ _ R |
    | Ctrl+W    | newWindow      |新たに別のZeroを起動                        | F _ _ _ |
    | Ctrl+X    | cut_explorer   |切り取り - エクスプローラー                 | F _ _ R |
    | Ctrl+@    | migemosrch     |あいまいインクリメンタルサーチ [^1]         | F L P R |
    | Ctrl+0    | MNumJmpList    |メモリナンバージャンプリスト表示            | F _ _ R |
    | Ctrl+1～9 | MNumJmpAdd1～9 |メモリナンバージャンプ1～9へ登録            | F _ _ R |
    | Ctrl+[    | max            |最大化/元に戻す                             | F _ P _ |
    | Ctrl+]    | min            |最小化                                      | F _ P _ |
    | Ctrl+Left | Leftlimit      |左端に移動                                  | F _ P R |
    | Ctrl+Right| Rightlimit     |右端に移動                                  | F _ P R |
    | Ctrl+Up   | Uplimit        |先頭に移動                                  | F L P R |
    | Ctrl+Down | Downlimit      |末尾に移動                                  | F L P R |
    | Ctrl+Tab  | zerolist       |Zero一覧                                    | F L P R |

    |キー         |名称            |機能                                      |対応窓   |
    |-------------|----------------|------------------------------------------|---------|
    | Shift+Ctrl+A| revAllmark     |全マーク反転                              | F L P _ |
    | Shift+Ctrl+O| dellallpos     |全窓位置削除                              | F _ _ _ |
    | Shift+Ctrl+V| textView       |内蔵テキストビュワー                      | F _ _ _ |

    |キー       |名称            |機能                                        |対応窓   |
    |-----------|----------------|--------------------------------------------|---------|
    | Alt+K     | mklink         |リンク作成                                  | F _ _ _ |
    | Alt+Right | forward        |進む                                        | F _ _ R |
    | Alt+Left  | backward       |戻る                                        | F _ _ R |
    | Alt+Up    | gUplimit       |グループ先頭に移動                          | F L P R |
    | Alt+Down  | gDownlimit     |グループ末尾に移動                          | F L P R |
 
* キー割り当て(内蔵テキストビュワー)  

    |キー       |名称            |機能                                        |
    |-----------|----------------|--------------------------------------------|
    |  F3       | next           |次を検索                     [^3]           |
    | Shift+F3  | prev           |前を検索                     [^3]           |
    | Shift+F10 | contextmenu    |コンテキストメニュー表示     [^3]           |
    | Ctrl+A    | select All     |全文章選択                   [^3]           |
    | Ctrl+C    | Copy           |コピー                       [^3]           |
    | Ctrl+F    | Find           |文字列検索                   [^3]           |
    | Ctrl+J    | Jump to line   |指定行ジャンプ               [^3]           |

* Zvキー割り当て(画像ビュワー)

    |キー       |名称            |機能                                        |
    |-----------|----------------|--------------------------------------------|
    |  E        |                |編集                         [^3]           |
    |  F        |                |ファイルを開く               [^3]           |
    |  Q        |                |終了                         [^3]           |
    |  V        |                |閲覧                         [^3]           |
    |  Z        |                |倍率指定                     [^3]           |
    |  0        |                |倍率 100%                    [^3]           |
    |  1-9      |                |倍率 10～90%                 [^3]           |
    |  +(;)     |                |拡大 +10%                    [^3]           |
    |  -        |                |縮小 -10%                    [^3]           |
    | Space     |                |次の画像                     [^3]           |
    | BkSp      |                |前の画像                     [^3]           |
    | ←        |                |左に移動                     [^3]           |
    | →        |                |右に移動                     [^3]           |
    | ↑        |                |上に移動                     [^3]           |
    | ↓        |                |下に移動                     [^3]           |
    |Shift+Space|                |前の画像                     [^3]           |
    |Shift+BkSp |                |次の画像                     [^3]           |
    |Shift+Enter|                |編集                         [^3]           |
    | Ctrl+C    |                |コピー                       [^3]           |
    | Ctrl+2-5  |                |倍率 200～500%               [^3]           |
    | Ctrl+Left |                |左端に移動                   [^3]           |
    | Ctrl+Right|                |右端に移動                   [^3]           |
    | Ctrl+Up   |                |上端に移動                   [^3]           |
    | Ctrl+Down |                |下端に移動                   [^3]           |

* 起動オプション  

    |書式                            |機能                                              |
    |--------------------------------|--------------------------------------------------|
    |ファイル or フォルダー          |/F, /D自動選択で起動                              |
    |/F=ファイル                     |指定ファイル位置に移動して起動                    |
    |/L=ファイル                     |起動中のZeroのファイル位置移動                    |
    |/D=起動フォルダー               |起動時のフォルダーを指定                          |
    |/P=Left,Top,Width,Height,WWidth |起動時の表示位置指定  WWidth:2画面幅              |
    |/S=ショートカットファイル       |新規Zeroを起動しショートカット先のフォルダーを開く|
    |/SF=ショートカットファイル      |/Sと同じ                                          |
    |/SL=ショートカットファイル      |起動中のZeroでショートカット先のフォルダーを開く  |

* コマンドの実行や、フォルダー指定時の環境変数使用方法  
    %環境変数%  
    
    例:  
        %windir%                → C:\WINDOWS  
        "%userprofile%\\Music"  → "C:\Users\xxxx\Music"  
        (重要：\は、2回記載必要)

* コマンドの実行や、フォルダー指定時に使用可能なマクロ
    |マクロ   |機能                                           |
    |---------|-----------------------------------------------|
    |$D, $d   | カレントドライブ                              |
    |$P, $p   | カレントフォルダーパス                        |
    |$F       | カレントファイル(フルパス)                    |
    |$f       | カレントファイル(フルパス、拡張子なし)        |
    |$C       | カレントファイル(拡張子あり)                  |
    |$c, $X   | カレントファイル(拡張子なし)                  |
    |$M       | マークファイル(フルパス)                      |
    |$m       | マークファイル(フルパス、拡張子なし)          |
    |$T       | マークファイル(拡張子あり)                    |
    |$t       | マークファイル(拡張子なし)                    |
    |$L       | リストファイル(フルパスのマークファイルを列挙したファイル。ファイル名(Zeroxxxx.lst)は自動生成される。)  |
    |$L2      | リストファイル $Lの拡張子なし                 |
    |$l       | リストファイル(マークファイルを列挙したファイル。ファイル名(Zeroxxxx.lst)は自動生成される。)  |
    |$l2      | リストファイル $lの拡張子なし                 |
    |$I       | 実行時入力(パラメータ)                        |
    |$i       | 実行時入力(圧縮ファイル名)                    |
    |$Z       | Zeroのフルパス                                |
    |$z       | Zeroのフォルダー                              |
    |$$       | '$'自身                                       |

* ドライブバー表示方法  
    「設定」→「基本設定」→「ドライブバー」で   
     ドライブバー表示： true - 有効
    とすることで、ドライブバーが有効になります。falseだと無効になります。  
    設定の反映には、Zeroの再起動が必要です。

* ツールバー表示方法  
    「設定」→「ツールバー設定」で
    ツールバー表示のチェックを入れることで、有効となります。
    また、コマンドのカスタマイズが可能です。
    コマンドによってはまだアイコンが準備できていないため、ツールバーに配置できるのはアイコンのあるコマンドのみになります。  

* 圧縮・展開の拡張  
    Zip, LZH以外の圧縮・展開は、別途DLLの準備が必要です。
    Zeroのフォルダーか、パスの通った場所に保存してください。  

    * 64bit版のZero  
      64bit用の圧縮・展開用DLLが必要です。  
      例えば、LZHの圧縮を行いたい場合は、  
      
        |項目      |設定値        |
        |----------|--------------|
        |拡張子    |lzh           |
        |DLL 64bit |LhaZero64.dll |
        |コマンド  |LhaZero       |
      
      ただし、どうしても、32bitのDLLを使用したい場合は、
      UNBYPASS.DLL(http://toro.d.dooo.jp/slplugin.html)経由で
      32bitのDLLを使用することが可能です。  
      例えば、LZHの圧縮を行いたい場合は、  
      
        |項目      |設定値        |
        |----------|--------------|
        |拡張子    |lzh           |
        |DLL 64bit |UNBYPASS.DLL  |
        |コマンド  |Unlha         |
        |必要DLL   |unlha32.dll   |
      
      とすることで、UNBYPASS経由でUNLHA32.DLLを使用できます。  

    * 32bit版のZero  
      32bit用の圧縮・展開用DLLのみ使用可能です。
      例えば、LZHの圧縮を行いたい場合は、  
      
        |項目      |設定値        |
        |----------|--------------|
        |拡張子    |lzh           |
        |DLL 32bit |unlha32.dll   |
        |コマンド  |Unlha         |

    * 64bit用圧縮・展開DLLの紹介(別途入手必要です)
      
      |拡張子    |DLL                                     |
      |----------|----------------------------------------|
      |7z, zip   |7-zip64.dll                             |
      |tar       |tar64.dll                               |
      |zip       |LMZIP64.DLL                             |
      |rar       |unrar64j.dll, unrar64.dll (両方必要です)|

* あいまいインクリメンタルサーチ  
    利用時は、別途 C/Migemoと辞書の準備が必要です。
    KaoriYaのHP(https://www.kaoriya.net/software/cmigemo/)から、
    Windowsバイナリ(migemo.dll)のダウンロードが必要です。この中に辞書(dict)も含まれています。  
    32bit版のZeroを使用している場合は、C/Migemo for Windows 32bit  
    64bit版のZeroを使用している場合は、C/Migemo for Windows 64bit  
    を使用する必要がありますので、組み合わせに気をつけてください。
    保存場所のデフォルトは、Zero.exe直下です。migemo.dllと dictフォルダーを保存してください。
    それ以外のファイルは使用しません。

* 32bit版、64bit版の違い  
    圧縮・展開で使用できるDLLが異なります。"圧縮・展開の拡張"の項目を参照してください。  
    64bit版は、Windowsフォルダー内部をオリジナルのまま扱うことができます。  
    32bit版は、OSのファイルシステムリダイレクターの影響でオリジナルの状態とは異なるOSにより置き換えられたフォルダー構成が表示されてしまいます。  
    例えば、32bit版で、Windows\System32フォルダーにアクセスすると、  
    x86系PCの場合、Windows\SysWOW64にリダイレクトされ、  
    ARM系PCの場合、Windows\SysArm32にリダイレクトされます。  
    また、レジストリエディタの実行においても、32bit環境用が実行されます。

* 開発環境  
    Delphi 12.1 Community Edition  
    C++Builder 12.1 Community Edition (LhaZero)

* 使用条件  
    * 64bit版  
      本プログラムはシェアーウェアです。著作権は、Y-Kuze(久世雄一)が所有します。
      本プログラムによる事故(大切なファイルの消滅など)が発生しても
      私は責任を持ちません。ご自身で責任が取れる方のみご使用ください。
      また、継続的に使用する場合は、Vectorのシェアレジ(レジサービス)にて送金をお願いいたします。
      https://www.vector.co.jp/soft/winnt/util/se523330.html

    * 32bit版  
      本プログラムはフリーウェアです。著作権は、Y-Kuze(久世雄一)が所有します。
      本プログラムによる事故(大切なファイルの消滅など)が発生しても
      私は責任を持ちません。ご自身で責任が取れる方のみご使用ください。

* 謝辞  
    下記のすばらしいコンポーネントやライブラリを使用させていただきました。
    作者の皆様にこの場を借りてお礼申しあげます。
   
    |使用コンポーネント/ライブラリ                |作者                                |
    |---------------------------------------------|------------------------------------|
    |フォルダ監視コンポーネント                   |Mr.XRAY 氏                          |
    |コンテキストメニューコンポーネント           |Mr.XRAY 氏                          |
    |日付ピッカー付き日付入力コンポーネント       |Mr.XRAY 氏                          |
    |SuperObject                                  |hgourvest 氏                        |
    |正規表現ライブラリ bregonig.dll              |K.Takata 氏                         |
    |TFormPanel                                   |Osamu Takeuchi 氏                   |
    |The Drag and Drop Component Suite for Delphi |Anders Melander 氏                  |
    |CheckCCode                                   |INOUE, masahiro 氏                  |
    |Fluent UI System Icons                       |microsoft                           |
    |LHA for Windows 95/98/Me [^4]                |小金丸信幸 氏, Tsugio Okamoto 氏    |
    |TurboPower Abbrevia                          |                                    |
    |SynEdit (TurboPack)                          |                                    |

    [^4]: https://github.com/ykuze/LhaZero から改変後のLhaZero32/64.dllの最新ソースコードを取得できます。

* 連絡先  
    * HP    : http://www.hi-ho.ne.jp/kuze/
    * E-Mail: kuze@hi-ho.ne.jp

* 変更履歴
    * 1.25.8
        * デフォルトエディタ/ビュワーにマークファイルを1つずつ実行するオプションON時の不具合修正
    * 1.25.7
        * ランチャー設定、拡張子対応設定のアプリ指定時にマークファイルを1つずつ実行するオプションを追加
        * デフォルトエディタ/ビュワーにマークファイルを1つずつ実行するオプションを追加
        * Ztext(0.17):複数ファイルのオープン不具合修正
    * 1.25.6
        * Zv(0.20):窓のスタイルを設定しているとき画像表示でエラーが出る不具合修正
        * Zv:Ctrl+マウスの拡大縮小動作の向きを反対に修正
        * 「非アクティブ時背景」にOS準拠を設定した場合、非アクティブ時にカーソル行が見えなくなる不具合修正
        * 画面更新処理変更(ハング対策)
    * 1.25.5
        * 「終了時の問い合わせ」設定に関して「全終了」への反映漏れ修正
        * 拡張子対応設定にてZvに渡すファイルの方法をマークファイルに変更
        * Zv(0.19):「最大表示」時、拡大縮小を行うと最大表示が自動解除されるように変更
        * Zv: フォルダorファイル名に空白文字がある場合正常に表示されない不具合修正
        * Zv:「追加起動禁止」時、複数ファイルを指定すると表示リストとして登録されるように変更
    * 1.25.4
        * 「前回終了状態の複数窓を復帰」の設定が無効だったのを修正
        * 「終了時の問い合わせ」の有無を設定できるように変更
        * Zv(0.18):窓のスタイルが「OS準拠」以外でスクロールバーが出ない不具合修正
        * Zv:「縮小 -10%」で10%未満になる不具合修正
        * Zv:ホイールで「次の画像」「前の画像」を操作可能に変更
        * Zv:Ctrl+ホイールで「拡大」「縮小」を操作可能に変更
        * Zv:複数ファイルを指定した際、一部のファイルが表示されない不具合修正
        * Zv:「窓と画像の連携なし」をキーカスタマイズに追加
    * 1.25.3
        * Zv(0.17)の「最大表示」のキーカスタマイズ対応
        * Zvとの連携動作改善(Sort条件)
    * 1.25.2
        * Zvとの連携動作改善
        * Zv(0.16):「最大表示」を追加
    * 1.25.1
        * フォルダーを先頭にまとめるソートモードを追加
    * 1.25.0
        * メインメニューなどのフォント設定の追加
        * Zv(0.15):Zeroのメインメニューなどのフォントを反映
        * Ztext(0.16):メインメニューなどのフォント設定の追加
    * 1.24.12
        * 2画面表示の際、ステータスバーの縦幅が狭い不具合を修正
        * 「フォルダー統合確認」の状態が、次回起動時に復元されない不具合修正
    * 1.24.11
        * ドライブバー非表示状態で「取り出し」が実行できない不具合修正
        * ワイルドカード設定などで表示ファイルがないときの不具合修正(sortなど)
    * 1.24.10
        * Zv(0.14):スペースを含むフォルダーにインストールされているとき、キー設定が起動しない不具合修正
        * ワイルドカード設定などで表示ファイルがないときの不具合修正
    * 1.24.9
        * アイコン取得時のハング改善
    * 1.24.8
        * Zv(0.13):キーカスタマイズ機能の追加
    * 1.24.7
        * Zv(0.12):「並び替え」を追加
        * 「ソートはロケール準拠」ON時の並び替え処理修正
        * Zero, Zv連携のマーク連携動作を改善
    * 1.24.6
        * Zv(0.11):「追加起動禁止」で画像を表示した際フォーカスをZvに移動するように修正
        * Zv(0.11):「Zeroに切替」追加
        * 複数ファイルの名前変更中に他のアプリにフォーカスを切り替えると変更対象を飛ばしてしまう不具合を修正
    * 1.24.5
        * Zv(0.10):「追加起動禁止」、「最前面表示」、「マークして次へ」、「マークして前へ」追加
        * 「実行アプリに渡すファイルの方法」で「ファイル」を選択したときの動作を修正
        * 複数リネームの「以降、連番で名前変更」で無限ループになる不具合を修正
    * 1.24.4
        * Zvの「Zero連携」でファイル送りした際、Zero側のマークが外れる不具合修正
        * Zv(0.09):「Zero連携」機能ON時、マーク操作できるように変更
    * 1.24.3
        * フォルダーコピー時の統合確認を有効/無効の動作が反対だったのを修正(1.24.2の不具合)
    * 1.24.2
        * Zv(0.08):「Zero連携」機能追加。ON時Zvの表示画像ファイルにZeroのカーソルが移動
        * フォルダーコピー時の統合確認を有効/無効にするチェックボックス追加
    * 1.24.1
        * 2画面表示への切り替え時のカーソル位置を改善
        * フォルダーコピー時の動作不具合修正(1.23.4の不具合)
    * 1.24.0
        * フッター情報欄のファイル数表示に、ファイルの合計サイズも合わせて表示するように変更
        * キー設定に「キー登録ジャンプ」を追加
        * 2画面表示の際、相手側の窓のPath長をフォルダー2個分に変更
    * 1.23.10
        * サロゲートペアの文字を含むファイル名の表示文字数がずれる不具合を修正
    * 1.23.9
        * サロゲートペアの文字を含むファイル名の表示でエラーとなる場合がある不具合を修正
    * 1.23.8
        * ファイル名の数字が大きいときにリネームに失敗する不具合修正
    * 1.23.7
        * 「名前変更」の拡張子非表示のときの初期選択範囲不具合を修正
        * 右クリックによるエクスプローラへのドラッグ＆ドロップに対応
    * 1.23.6
        * 名前変更の自動0埋め連番機能の不具合修正(1.23.2の不具合)
        * フォルダーコピー時における名前の自動生成不具合を修正
        * ファイル名のクリップボードコピー時のメッセージ表示を設定でON/OFFできるように変更
    * 1.23.5
        * 同一フォルダー名のコピー/移動で条件に関係なく実行してしまう不具合修正
    * 1.23.4
        * ショートカット経由で最小化して起動した場合、Zero修了時にエラーが発生する不具合修正
        * 同一フォルダー名のコピー/移動で名前変更可能に変更
    * 1.23.3
        * 空白を含むフォルダーにZeroをインストールした場合、設定画面が表示できない不具合修正
        * 「窓位置の保存」、「復帰」、「全窓位置削除」を追加
    * 1.23.2
        * LhaZero32/64.dllでフォルダが圧縮できない不具合修正(C++Builder12.1で再コンパイルしただけ)
        * ファイル名の数字が大きすぎるとリネームできない不具合修正
    * 1.23.1
        * リネーム失敗したとき入力した内容が消える不具合を修正
        * 2画面モードのTABの切り替え時、ファイルサイズなどの表示位置が切り替わらない不具合修正
        * 「リンク(ショートカット、ジャンクションなど)作成」の追加
        * 「ショートカットのリンク先に移動」の追加
        * 起動オプションを追加(ショートカットのリンク先移動関連)
        * 拡張子設定のlnkファイルに対する動作変更(Shift+Enter)
    * 1.23.0
        * 右クリックメニューの「新規作成」の不具合修正
        * ドロップダウンリストの表示行数を設定可能に変更
        * コピー時のパス入力の補完に「ネットワーク接続先設定」の内容も反映
        * ファイルマーク時の情報表示が、Pathの表示と重なる不具合修正
    * 1.22.8
        * アイコン表示のチラツキ改善(1.22.7の不具合)
        * ファイル操作時のIME自動オフ機能を無効にできるように変更
    * 1.22.7
        * アイコン情報取得スレッドと表示処理が同時発生した時、異常終了する不具合修正
    * 1.22.6
        * リスト窓で名前変更の自動連番機能が正しく動作しない不具合修正
        * 名前変更で何もせずにESCで抜けた場合マークが外れる不具合修正
    * 1.22.5
        * 「標準テキストビュワー設定」で削除ボタンがエラーになる不具合修正
        * 名前変更の自動連番機能が正しく動作しない不具合修正
        * 名前変更の自動連番機能に0埋め連番機能を追加
    * 1.22.4
        * Ztext(0.15)TAB幅設定が反映されない不具合再修正
        * アクティブになったときにハングすることがある不具合修正
    * 1.22.3
        * PageDownで半分スクロールモード時に最終ファイルに移動できない不具合修正
        * Ztext(0.14)フォント名、TAB幅設定が反映されない不具合修正
    * 1.22.2
        * スクロールにて表示が崩れる場合がある不具合を修正
        * 名前変更時の拡張子表示ON/OFFのショートカット動作を改善
        * タスクバーからの終了が失敗する不具合を修正
        * "追加起動禁止"機能を追加
    * 1.22.1
        * ファイル窓以外も縦スクロールのホイール動作を共通で切り替えるように修正
        * PageUp/Downで半分スクロールモードを追加
    * 1.22.0
        * コピー先指定などの「動作中のZero」に、スペースを含む自分自身のパスが正常に表示されない不具合修正
        * コピー先指定などの窓サイズを記憶するように変更
        * ファイル窓の縦スクロールOFFのとき、ホイール動作が1行単位になる不具合修正(1.18.0の不具合)
        * 縦スクロールのホイール動作に、半画面、１画面を選択できるように変更
        * 内蔵ビュワーを廃止し、Ztextに完全移行。「@view切替」設定の廃止
        * ZipZero32/64.dll(0.05): 展開(解凍)進行中のファイル名が表示されない不具合修正
    * 1.21.10
        * ネットワーク接続先のルートフォルダーで、「親フォルダーへ」の動作がエラーとなる不具合修正(1.21.9の不具合)
    * 1.21.9
        * ネットワーク接続先のフォルダーで、「ルートフォルダーへ」が動作しない不具合修正
        * USBや、ディスクの取り出しをCtrl+Oで実施できるように変更
    * 1.21.8
        * 読み取り専用ファイルの別ドライブへの移動が失敗する不具合を修正(1.20.2の不具合)
        * 参照窓のドライブバーにボタンが表示されない不具合修正(1.21.2の不具合)
    * 1.21.7
        * ドライブバーのメディアの取り出し機能がUSB-HDDで動作しない不具合を修正
        * USBメモリなどは、ドライブバーのメディアの取り出し直後(USB引き抜く前)にボタンを削除するように変更
        * ドライブバーのフォント(太文字)の初期値がONになっていたのをOFFに修正
    * 1.21.6
        * メモリナンバージャンプの登録動作を改善
        * ドライブバーのアイコン非表示の時ボタンの並びが崩れる不具合修正(1.21.5の不具合)
        * ドライブバーの幅を縮小
        * ドライブバーにメディアの取り出し機能を追加
        * ドライブバーのアイコンを光ディスクドライブの自動再生に同期して変更するように改善
    * 1.21.5
        * シンボリックリンクの動作不具合を修正(1.16.6の不具合)
        * 小文字のドライブ名を指定するとドライブバーの表示が正常にアクティブにならない不具合修正
        * 移動などのフォルダー指定時で'\'で始まる絶対パス指定の動作不良を修正(1.19.5の不具合)
        * ドライブバーの更新方法を変更し高速化
    * 1.21.4
        * ドライブバーへの「ネットワーク接続先設定」の一覧表示をON/OFFできるように変更
        * フォルダーの初期アイコンの生成方法変更
    * 1.21.3
        * コマンド名「ネットワークドライブ」を「ネットワーク接続」に修正
        * ドライブバーの「ネットワーク接続」釦が動作しない不具合を修正(1.21.2の不具合)
    * 1.21.2
        * ドライブバーの文字サイズが大きいとき枠からはみ出る不具合修正
        * 「ネットワーク接続先設定」の登録内容をドライブバーにも反映
    * 1.21.1
        * コンパイラのバージョン変更(Delphi 12.1 CE)
        * ドライブバーのアイコンOFF時の表示サイズを小型化
        * フッター情報のフォントを情報パネルに合わせる
        * ファイル窓での連続リネーム時にマークが外れないときがある不具合修正
        * 属性変更でサブフォルダー内も変更可能に変更
        * コピー進捗表示で文字が窓に収まらない時がある不具合を修正
        * ファイル検索のカレンダーのタイトル部分の表示を改善
    * 1.21.0
        * ドライブバーのアイコンをOFFにする機能の実装
        * 「指定フォルダーへ」のキー入力欄でのCtrl+Cの動作不具合を修正
    * 1.20.7
        * ドライブバーの更新が連続で発生した際の動作の安定化
        * LhaZero32/64.dll(0.08): フォルダー指定の展開時にサブフォルダーがカレントフォルダーにも作成される不具合修正
        * 「ファイル移動」で、フォルダーの移動の高速化
    * 1.20.6
        * ソート条件の「ファイルのみ」を設定に追加
        * 外部の圧縮・展開DLLでのファイル内部閲覧時、時間がずれる不具合修正
        * LhaZero32/64.dll(0.07): ローカルタイム処理を修正
        * ZipZero32/64.dll(0.04): ローカルタイム処理を修正
        * 圧縮ファイル展開に自動フォルダー作成機能を追加
    * 1.20.5
        * 「2画面表示」OFF時に左窓からの移動履歴の引き継ぎができていない不具合を修正
        * 一部のルートディレクトリに移動できない不具合を修正
        * 圧縮、展開後に背景色が非アクティブ色のままになる不具合修正
        * ソート条件に「ファイルのみ」を追加
    * 1.20.4
        * ネットワークドライブ(UNCパス)にフォルダーが作成できない不具合修正(1.20.0の不具合)
        * ルートディレクトリにフォルダーが作成できない不具合修正(1.20.0の不具合)
        * 「2画面表示」のフォルダー表示を改善
    * 1.20.3
        * 「ドライブ変更」などの表示位置の不具合修正(1.20.0の不具合)
        * 2画面表示時、TAB(トグルでZeroを切替)での背景更新もれを修正
        * 2画面表示時、マウスでの窓切替での背景更新もれを修正
        * 参照窓で「ジャンプ」などがエラーになる不具合を修正(1.20.2の不具合)
        * 「ジャンプ(2画面反対側)」実行時、上部のフォルダー表示が正しくないのを修正
    * 1.20.2
        * 「ジャンプ」などのコンテキストメニュー位置の不具合修正(1.20.0の不具合)
        * UNCパスでのコピーなどができない不具合を修正(1.20.0の不具合)
        * ファイル窓の縦スクロールONのとき2画面表示が崩れる不具合修正(1.20.0の不具合)
    * 1.20.1
        * UNCパスにアクセスできない不具合修正(1.20.0の不具合)
        * 「キーヘルプ」のをF1キーに割り当て
    * 1.20.0
        * 「2画面表示」の左右窓切り替え時に情報窓のFilesなどが更新されない不具合修正(1.18.2の不具合)
        * 「2画面表示」時に両フォルダー情報を同時に表示
        * 非アクティブ窓の背景色を変更する機能を追加
        * 「キーヘルプ」を追加
        * 接続デバイスが変わったときドライブバーが非選択状態になる不具合を修正
        * 長いファイルパスでの「削除」に失敗するのを修正
        * 長いファイルパスでの「名前変更」に失敗するのを修正
        * 左窓のフォントサイズのずれを修正
    * 1.19.11
        * 複数ファイルの「名前変更」でOK釦を押すと次の編集画面が選択状態にならない不具合修正
    * 1.19.10
        * 自分自身にコピーなどをする場合の上書き確認の選択を限定するように修正
        * 絵文字を少しだけ対応
        * Zeroがアクティブになるときの再描画条件を設定できるように変更(RefreshType)
    * 1.19.9
        * Zeroがアクティブになるときの再描画条件を修正
        * 圧縮ファイル内直視後の、2画面表示不具合をさらに修正
    * 1.19.8
        * 圧縮ファイル内直視後の、2画面表示不具合を修正
        * 圧縮窓で「2画面表示」が動作してしまう不具合修正
        * LhaZero32/64.dll(0.06): "e"による展開をフォルダなし展開に変更
        * 2画面表示時、右クリックでもアクティブ窓を切替するように修正
    * 1.19.7
        * Zero本体のフォルダーにある圧縮・展開DLLが無効になる場合がある不具合修正
        * 2画面時の「ジャンプ」などの表示位置を各ファイル窓に修正
        * ジャンプ(2画面反対側)を追加
    * 1.19.6
        * コピー時などに相対パスを指定すると失敗する不具合を修正(1.19.5の不具合)
        * 2画面表示の左窓の背景色をカスタマイズできない不具合を修正
        * 2画面時はトグル切替を左右窓切替に適用できるように変更
    * 1.19.5
        * フォルダーの移動が不安定になる不具合を修正(1.18.3の不具合)
        * 2画面表示のコピーなどの操作時、受信側の表示位置を変更
    * 1.19.4
        * 通常と2画面表示の画面幅の切替不具合修正
    * 1.19.3
        * 画面幅の復帰の不具合修正(1.19.2の不具合)
        * ファイル検索のファイルへ"O+Alt"で移動後の縦スクロールつまみ位置修正
    * 1.19.2
        * 次回起動時の通常と2画面表示の画面幅の復帰の不具合修正
    * 1.19.1
        * 次回起動時の通常と2画面表示の画面幅の復帰の不具合修正
        * リスト窓の内部処理のシュリンク
    * 1.19.0
        * ×釦での終了ができない場合があるのを修正
        * USB経由のスマホのフォルダーに対し、複数起動時の連携を強化
        * 2画面表示の画面幅を別管理で記憶できるように変更(IsSaveWWidth=true)
    * 1.18.8
        * USB経由のスマホに対して「コピー」「ファイル移動」が動作しない不具合修正(1.3.1の不具合)
    * 1.18.7
        * リスト窓に表示されるファイルサイズの桁数が不足する不具合を修正
        * スマホなどのフォルダーに移動できない不具合修正(1.16.6の不具合)
        * Ztext(0.13)URL, Mailの下線はCtrlキー押したときのみに変更
    * 1.18.6
        * 「2画面表示」の左窓用縦スクロールバーで操作できない不具合修正
        * 「2画面表示」のファイルがない部分をクリックしてもフォーカスが移動するように修正
        * 「2画面表示」の左窓のファイル情報がリアルタイム更新されない不具合を修正
        * 「2画面表示」をオフすると縦スクロール設定、表示行数設定がデフォルト設定に戻る不具合修正
        *  縦スクロールの「次の画面に移動」の動作を改善
    * 1.18.5
        * 「2画面表示」で相手側のカーソル位置をコピーしたファイル位置に移動するように変更
        * 「2画面表示」で圧縮、展開時、反対側のフォルダーを指定するように変更
        * 前後にスペースが含まれているフォルダーに移動できない不具合修正
        * 展開後、カーソルが下線になるのを修正
    * 1.18.4
        * リスト窓表示直後にカーソル移動するとエラーが発生する不具合修正
        * リスト窓で「ワイルドカード」指定時の、縦スクロールバーの不具合を修正
        * 「ネットワーク接続設定」「圧縮・展開設定」を実行するとエラーが出る不具合を修正
        * 圧縮後、カーソルが下線になるのを修正
    * 1.18.3
        * 「2画面表示」でコピー後、現在フォルダーがずれる不具合を修正
        * 「2画面表示」の左側の窓にカラー設定が反映されない不具合修正
        * 暗号化された圧縮ファイルの直視モードでエラーを表示するように修正
        * 「ワイルドカード」、「指定フォルダーへ」後、カーソルが下線になるのを修正
        * 圧縮・展開設定に、"必要DLL"の項目を追加
        * 非アクティブ時の表示設定を追加(1.17.x同様、下線カーソルをOFFにできます)
        * ZipZero32/64.dllでのZip直視にて日付がずれる不具合修正　
    * 1.18.2
        * 「2画面表示」の左側の窓のアイコン表示、ソートなどの設定が変更できない不具合修正
        * 「2画面表示」の左側の窓のマーク情報が正しく表示できない不具合修正
        * 「窓のスタイル」がデフォルトでない場合、エラーが表示される不具合を修正(1.8.0の不具合)
        * 「ファイル検索」後、ファイル窓の情報パネルが表示されなくなる不具合修正(1.8.0の不具合)
        * 「ボリュームラベルの変更」を追加
        * 非アクティブの際、カーソル形状を下線に切り替える動作の不具合を修正
    * 1.18.1
        * 「2画面表示」の左右移動の割り当て漏れを修正
        * 「2画面表示」時の「ファイル移動」が正しく動作しないのを修正
        * 縦スクロールONのとき、末尾に移動コマンドの不具合を修正
    * 1.18.0
        * 「2画面表示」追加
        * 「上書き(初期値)」を設定できるように変更
        * メモリナンバージャンプ関連のキー割り当てが、参照窓に反映されない不具合を修正
        * フォルダーの名前変更で拡張子の処理を行っていた不具合を修正
        * 「ワイルドカード」指定時の、縦スクロールバーの不具合を修正
        * 圧縮窓でのファイルサイズが6桁までしか表示されない不具合を修正
    * 1.17.4
        * 「サイズ情報表示」をESCで閉じれるように変更
        * 2.1GBより大きなサイズのファイルを正しくサイズ順にソートできない不具合を再度修正
    * 1.17.3
        * ドライブバーのアクティブなドライブボタンを押すと解除される不具合を修正
        * 「サイズ情報表示」、「プロパティ」追加
        * 2.1GBより大きなサイズのファイルを正しくサイズ順にソートできない不具合を修正
        * 「ランチャー設定」「ジャンプ設定」においてグループ内の項目追加の不具合を修正
    * 1.17.2
        * ネットワークドライブ(Ctrl+L)の不具合修正(1.16.6の不具合)
        * Ztext(0.12)検索の窓に設定文字サイズが反映されない不具合修正
        * Ztext(0.12)インデント補助のラインを削除
    * 1.17.1
        * 「キー設定」で"アプリ起動"を設定すると、エラーが出る不具合修正
        * ドライブバーをONにすると、エラーが出る不具合修正
        * Ztext(0.11)のPageUp/Downの動作不具合を修正
        * Ztext(0.11)の文字エンコードの切替でエラー表示が出るのを修正
        * Ztext(0.11)で、検索の方向を変えた場合でも、すぐに次の候補に移動するように修正
    * 1.17.0
        * ファイル窓などでの縦スクロールモードを追加
        * 設定(ZeroConfig)結果を、再起動なしに反映するように変更
        * Ztext(0.10)の表示部をScintillaから、SynEditに変更
        * Ztextの検索履歴の不具合を修正
        * ZtextのURI(URLなど)のリンク先のオープンは、Ctrl+クリックに変更
    * 1.16.7
        * キー設定でESCに「何もしない」を割り当てたときの動作を改善
        * 管理者で実行されている場合、タイトルバーに"管理者"の表示をするように変更
    * 1.16.6
        * キー設定の「何もしない」が上手く動作しない不具合を修正
        * フォルダー移動時、指定フォルダーがないときその親フォルダーに移動するように変更
        * リスト窓のカレントフォルダーのファイルを移動するとき、コピー＆削除になる不具合を修正
    * 1.16.5
        * 移動処理で移動先のドライブ名を小文字で指定すると移動がコピー＆削除の動作になる不具合修正
        * リスト窓でファイルサイズの表示サイズが固定になっていたのを修正
    * 1.16.4
        * Zv(0.07):「次の画像表示」で画像ファイルがないとき例外エラーが発生する不具合修正
        * LhaZero32/64.dll(0.05): コンパイラ変更。1.16.x系でLZHの処理ができない不具合修正
        * フォルダー／特殊ファイルの削除指定の初期値が削除しないのときは必ず確認画面を出すように変更
    * 1.16.3
        * Zv(0.06):圧縮ファイル中に画像ファイルがないとき例外エラーが発生する不具合修正
        * リスト窓の「名前変更」の不具合を修正
        * リスト窓終了時に、ファイル窓を最新状態に更新するように修正
        * 直前の全終了状態の各窓サイズの復元の不具合を修正
    * 1.16.2
        * Zv(0.05):圧縮ファイル中の画像表示に対応
        * Zv(0.05):右クリックメニューに、「実行」を追加
        * Zv(0.05):スタイル変更機能を追加
        * Ztext(0.03):スタイル変更機能を追加
        * 「窓のスタイル」の「文字くっきり」選択時、情報パネルの文字色が黒色になる不具合修正
        * 「拡張子対応設定」に圧縮ファイルに対する"V"による動作設定を追加
    * 1.16.1
        * フォルダー作成時などに、裏に表示されているファイル窓のカーソルが先頭に移動してしまう不具合修正
        * 高DPI環境でタイトルバー、メインメニューサイズが小さくなる不具合修正
        * 全角数字を含むファイル名の「名前変更」でエラーになる場合がある不具合修正
    * 1.16.0
        * コンパイラーをDelphi11.3に変更
        * 情報パネルのドライブ情報設定でファイル数の表示を行う場合、全ファイルサイズも表示するように変更
        * キーカスタマイズでキーを無効にするために「何もしない」というコマンドを追加
        * 「情報パネルのドライブ情報設定」にてボリュームラベルの表示を追加
        * 「ワイルドカード」に「フォルダー含む」を追加
        * 「マウスクリック時マーククリア」の設定を追加
    * 1.15.4
        * <..>行に表示されるファイルサイズの合計値が表示枠を超える不具合を修正
        * ファイル窓のファイル情報が更新されたときの内部処理(合計ファイルサイズ再計算など)を修正
        * Zeroがアクティブになる度にドライブバーも更新するように修正
        * ネットワークドライブに移動した際、ドライブバーの選択状態が解除されない不具合を修正
    * 1.15.3
        * 「名前変更」に拡張子非表示の機能追加
        * ファイル窓の「ソートのグループ化」の状態を、参照窓などに引き継ぐように修正
        * 実行形式のファイルに対しても、拡張子対応設定を有効に変更
    * 1.15.2
        * 「ソートはロケール準拠」の有効の種類を、２種類に変更
        * 窓のスタイルがZero標準以外の場合のアイコンを黒っぽい色に変更
    * 1.15.1
        * 「キー設定」でウィンドウ系コマンドが割り当てできない不具合を修正
        * ソートをロケール準拠としたとき、数字の並びはエクスプローラー同様に値順として並べるように変更
        * ウィンドウ系コマンドの規定値(窓サイズの規定値)を設定できるように変更
        * 「横に並べる」で、自身は左。他は右に配置するように変更
    * 1.15.0
        * 並び替え用コマンドを追加(sortnamef/b, sortdatef/b, sortsizef/b)
        * 名前順が現在ロケールに従うか否かを選択できるように変更
        * 「ソートの種別」が「Zero.iniの値」のとき、参照窓のソート条件はファイル窓に合わせるように変更
        * ファイルリスト取得内部処理の変更(FindFirst→FindFirstFileEx)
        * スタイル変更機能を追加
        * 「ドライブ変更」の窓サイズを保存するように変更
        * 隠し・システムファイル非表示の場合、親フォルダー<..>が非表示になる場合がある不具合を修正
        * ウィンドウ操作系コマンド追加(縦/横に並べる、並べて表示、重ねて表示)
        * 参照窓に「進む」「戻る」追加
        * コピー時などのフォルダー入力時の動作を修正
    * 1.14.4
        * OK, Cancelボタンでは、設定(ZeroConfig)の窓サイズが保存されない不具合を修正
        * 設定(ZeroConfig)のツリー部分が非アクティブの場合でも、選択項目を色分けするように修正
        * 拡張子対応設定(ZeroConfig)で、Enterなどの項目を削除した際、結果が保存されない不具合を修正
        * 「グループ先頭/末尾に移動」の動作改善(既に端にいる場合、次のグループに移動する)
    * 1.14.3
        * 「Zero一覧」、「コピー」などの「動作中のZero」にスペース込みのフォルダーが表示されない不具合を修正
        * ネットワーク窓での「ネットワーク接続先設定」表示の末尾切れを修正
        * 「ネットワーク接続設定」(ZeroConfig)の編集不具合を修正
        * コピー時などのフォルダー入力時のEnterキー動作を修正
        * 「前のZeroに切替」の動作を変更
    * 1.14.2
        * 設定(ZeroConfig)の窓サイズの保存方法を修正(1.13.3の不具合)
    * 1.14.1
        * Pathラベルをクリックで、ドライブ変更ができるように変更
        * 設定(ZeroConfig)の部品配置を設定窓のサイズに合わせるように修正
        * 「キー設定」で "[", "]", "," に割り当てできるように修正
        * 「キー設定」でアプリを複数設定しても1つしか動作しない不具合を修正
    * 1.14.0
        * 「ドライブ変更」画面で、ダブルクリックでもドライブを選択できるように変更
        *  フォルダー指定時のフォルダー入力候補表示を改善
        * 「前のZeroに切替」を追加
        * 拡張子対応設定で、Ctrl+Enterの項目を追加
        * 拡張子対応設定の初期設定を変更
        * 「名前変更」の窓幅を保持するように変更
        * 「フォルダー作成」や「コピー」の名前入力で失敗したとき、入力内容を保持した状態で再入力できるように修正
        * 「キー設定」の入力補助に、"Enter"を追加
    * 1.13.5
        * 「名前変更」で失敗したとき、入力内容を保持した状態で再入力できるように修正
        * フォルダーのコピー時のタイムスタンプ処理を修正
    * 1.13.4
        * アイコン表示有無設定が、ファイル窓以外に適用されていない不具合を修正
        * ソートのグループ化の設定が、ファイル窓以外に適用されていない不具合を修正
        * ファイル名のコピーなどで、実行後、ファイルマークが消えない不具合を修正
        * マーク記号の設定が、ファイル窓以外に適用されていない不具合を修正
    * 1.13.3
        * ファイル名の末尾が"(数字)"となっている場合「名前変更」ができない不具合修正(1.7.0の不具合)
        * 設定(ZeroConfig)の窓サイズを保存するように変更
    * 1.13.2
        * 「キー設定」(ZeroConfig)にアプリケーションキー(メニューキー) (application)を設定できない不具合修正
    * 1.13.1
        * フォルダー入力候補を選択できるように修正。"現行フォルダー" or "履歴"(従来動作)
    * 1.13.0
        * 「ファイルのタイムスタンプ変更」の操作性改善
        * フォルダーのコピー時、タイムスタンプもコピーするように修正
        * 「グループ先頭に移動」(Alt+Up)「グループ末尾に移動」(Alt+Down)を追加
        * コピーなどのフォルダー指定時、フォルダー入力候補を表示するように変更
        * 「キー設定」にアプリケーションキー(メニューキー) (application)を追加
        * アプリケーションキーを「右クリック(コンテキスト)メニュー」に割り当て
    * 1.12.5
        * UNCパスに対する「ファイル移動」が遅いのを修正
        * テキストビュワーZtextに関して、URL, Mailアドレスをクリックして開けるように変更
        * 「指定フォルダー(ディレクトリ)へ」「ドライブ変更」で元のフォルダを指定したときの動作を改善
    * 1.12.4
        * ZipZero32/64.dllで暗号化ファイルの展開に対応
        * 参照窓にCtrl+C/X/V(コピー、切り取り、貼り付け - エクスプローラー)を追加
    * 1.12.3
        * 「ファイル検索」の「前回」表示でフォルダが表示されない不具合修正
    * 1.12.2
        * 「ワイルドカード」の「リアルタイム反映」の動作改善
    * 1.12.1
        * 「基本設定」のデータの保存の不具合修正
    * 1.12.0
        * ツールバー追加
        * ソートのグループ化の設定を「基本設定」→「一般」に追加
        * 1クリックソートコマンド「名前順」「日付順」「サイズ順」を追加
        * 1クリック表示切替「隠し・システムファイル表示」を追加
        * 「基本設定」→「一般」→「先頭・末尾間の移動」に"先頭or末尾に移動。ループなし"を追加
    * 1.11.3
        * 「拡張子対応設定」を圧縮ファイルにも適用するよう変更
    * 1.11.2
        * 「フォルダー作成」で失敗したときのチェックを強化
        * USB経由で接続されたスマホのフォルダー内で「フォルダー作成」ができない不具合修正
        * USB経由で接続されたスマホのフォルダー内で「削除」処理の進行状況を表示するように変更
    * 1.11.1
        * 「戻る」で履歴の範囲外まで処理してしまう不具合修正
        * 「ファイル検索」の期間の日付の初期値を本日に修正。期間指定後は、次回の日付の初期値に変更
        * ファイル検索時およびリスト窓の"Dir"を、"Path"に変更
        * 「ファイル検索」に前回の検索結果を表示できる「前回」ボタンを追加
        * USB経由で接続されたスマホのフォルダー名の表示を改善
    * 1.11.0
        * ファイル移動時、編集中などで削除できない場合、リトライできるように修正
        * 情報パネルの"Dir"を、"Path"に変更
        * マーク記号を指定できるように変更
        * 表示する列数の最大数を指定できるように変更
        * ファイル名の最小文字数、拡張子名の最小文字数を指定できるように変更
        * アイコン表示有無の設定を追加
        * 「ワイルドカード」入力をキャンセルした際、キャンセルされてない不具合修正
        * 「ワイルドカード」入力時、「リアルタイム反映」機能を追加
    * 1.10.2
        * 現フォルダーのファイル情報更新中にフォルダー変更を行う際の動作を安定化
    * 1.10.1
        * コマンド用のアイコン補充
        * ワイルドカード使用時、他のソフトにより自身のフォルダーが更新されると異常終了する不具合修正
        * ワイルドカード指定の履歴が表示されない不具合修正
    * 1.10.0
        * テキストビュワーのメモリーリーク修正
        * テキストビュワーモジュールScintillaを 5.3.1に更新
        * テキストビュワーの「ファイル」→「開く」で行数表示枠の幅を再調整するように修正
        * テキストビュワーZtextを追加
        * 「設定」→「基本設定」→「一般」に「@view切替」を追加。Ztextがデフォルト。
        * 圧縮窓で、空白を含むファイル名のファイルが閲覧できない不具合修正
        * 「ドライブ変更」時、「フォルダー毎にカーソル位置を記憶」の設定が反映されない不具合修正3
        * 圧縮窓でフォルダーへの移動ができない不具合修正
        * 圧縮窓でファイルが閲覧/編集ができないときがある不具合修正
        * 新Zip, Tar, TGZ, TBZ圧縮・展開用DLL ZipZero32/64.dllを追加
        * 旧Zip圧縮・展開用DLL DelZipWrap/DelZip***.dllを削除
    * 1.9.3
        * 「ドライブ変更」時、「フォルダー毎にカーソル位置を記憶」の設定が反映されない不具合修正2
        * 内部処理のシュリンク
        * ファイル窓 - 圧縮窓間のソート条件を同一化
    * 1.9.2
        * 「ドライブ変更」時、「フォルダー毎にカーソル位置を記憶」の設定が反映されない不具合修正
        * 「キー設定」の各「アプリ起動」にタイトル設定を追加
        * 「圧縮・展開設定」のZip(7-zip)のオプションを見直し
    * 1.9.1
        * マクロ($L2, $l2, $I, $i)の追加
    * 1.9.0
        * LZH形式用のDLLの進行状況表示変更(LhaZero32/64.dll ver0.04)
        * 圧縮・展開設定(Pack.json)の初期値に、7-zip32/64を用いた自己展開圧縮(exe)を追加
        * 圧縮・展開設定(Pack.json)の初期値の、7-zip32/64用オプションを見直し(-rを外す)
        * Win11 22H2のIME(不具合)で、日本語を入力する際クラッシュする対策
        * 「アプリ起動」を追加
        * 「キー設定」でキーを設定できない不具合修正
    * 1.8.4
        * 「ファイルのタイムスタンプ変更」にてサブフォルダー内の経過表示も行うように修正
        * キーカスタマイズにキーパッドの'Num0'～'Num9'を追加
        * 「メモリナンバージャンプリスト表示」キーカスタマイズ可能に変更
        * 「メモリナンバージャンプで指定フォルダーへ」キーカスタマイズ可能に変更
        * 「メモリナンバージャンプ1～9へ登録」キーカスタマイズ可能に変更
    * 1.8.3
        * コピー、移動時に新しいフォルダーを作成してもファイル窓に反映されない不具合を修正
        * 「ファイルのタイムスタンプ変更」に経過表示が表示されない場合がある不具合修正
    * 1.8.2
        * ルートフォルダーへの移動時、カーソル位置を移動前のフォルダーに合わせる
        * 現在フォルダーがルートフォルダーの場合、ルート／親フォルダーへの移動を無視するように変更
        * 「新規ファイル編集」でファイル名に空白を含む場合、単一ファイル名として処理するように変更
        * 「実行」でファイル名に空白を含む場合、自動で'"'で囲むように変更
        * 選択してカーソル移動(sleft, sright, sup, sdown)のキーカスタマイズ対応
        * ファイル移動時、移動しなかったファイルも強制削除するオプション追加
        * 「ファイルのタイムスタンプ変更」に経過表示を追加
        * 「名前変更」で既存ファイルを削除できるように変更
        * 「設定」→「圧縮・展開設定」のツリー部へDLL名も表示追加
    * 1.8.1
        * カーソル移動(Left, Right, Up, Down)のキーカスタマイズ対応
        * リスト窓で左右のカーソルキーを押すと表示が崩れる不具合を修正
        * キー設定(ZeroConfig)のキー入力時の動作改善
    * 1.8.0
        * 作業後マーククリア条件"ClearMarkType"を設定できるように変更
        * ファイル窓でフォルダー変更時に正常にファイル一覧が取得できないことがある不具合修正
    * 1.7.4
        * 圧縮窓使用後、動作が不安定になる不具合修正
    * 1.7.3
        * ワイルドカード指定時';'が余分にある場合、アクセス違反が発生する不具合修正
        * 「編集」実行後、ワイルドカード文字「*」を自動入力するオプションが強制OFFになる不具合修正
        * フォルダーの無限ループコピー/移動を中断するように修正
    * 1.7.2
        * 削除などでファイルが0になった場合に例外エラーが発生する不具合修正
        * コピー、移動、削除でファイル数が変更になった場合、ファイル数情報が更新されない場合がある不具合を修正
        * 高DPIモニタ環境で、ファイル情報がずれる不具合を修正
    * 1.7.1
        * マルチモニター環境でサブモニターが、メインより左や、上に配置されている場合の動作修正
        * LZH(Header Level=2)のファイル内部閲覧時、時間がずれる不具合修正(LhaZero32/64.dll)
        * 参照窓での「ファイル検索」が正常に動作しない不具合修正
        * 圧縮窓のマクロ展開動作で$F/fをテンポラリの展開パスに修正
        * ワイルドカード文字「*」を自動入力するオプションを追加
    * 1.7.0
        * 開発環境のDelphiを10.4.2に変更
        * 正規表現ライブラリを bregonig.dll に変更
        * 「シャットダウン」「再起動」時に確認を取るように変更
        * ファイル数 0 のドライブに移動したとき範囲外エラーが出る不具合修正
        * 「削除」時のデフォルト値(ゴミ箱へ, 削除, キャンセル)を設定できるように変更
        * 上部の情報パネルにドライブ情報(空き容量など)を表示できるように変更
        * LZHのファイル内部閲覧時、時間がずれる不具合修正(LhaZero32/64.dll)
        * 7-zip用に展開先オプション追加
    * 1.6.7
        * マクロ展開の不具合を修正(1.6.5のバグ)
    * 1.6.6
        * キー設定(ZeroConfig)の設定の更新などが動作しない不具合修正
    * 1.6.5
        * 「ファイルのタイムスタンプ変更」でフォルダーのタイムスタンプが変更できない不具合を修正
        * スペースを含むフォルダーに関してマクロ展開の不具合を修正
        * Zv(0.04):「画像を窓に合わせる」を追加
        * 設定(ZeroConfig)のタイトル部の表示を修正
    * 1.6.4
        * リスト窓で「圧縮ファイルの参照」が動作してしまう不具合を修正
        * ファイル検索、圧縮窓の動作を改善
        * 7-zip32/64対応として、圧縮窓の内部処理変更(全ファイルリスト取得を *.* から * に変更)
        * 参照窓に「ネットワークドライブ」、「ファイル検索」を追加
        * 圧縮・展開設定(Pack.json)の初期値に、7-zip32/64でのzip対応を追加
    * 1.6.3
        * 設定(ZeroConfig)の表示処理の改善
        * ファイル数が少ないとき、スクロールバーをマウスでクリック後、キー操作が不能になる不具合修正
        * ワイルドカード処理の修正(1.6.2のバグ)
    * 1.6.2
        * 圧縮窓終了時、圧縮・展開用DLLを解放するように修正
        * 外部DLLを用いた圧縮・展開においてASCII文字以外の文字(UTF-8)を正常に扱えない不具合を修正
        * ワイルドカード処理の修正(例 *abc*.* が、xxx.abc にヒットする不具合を修正)
        * 圧縮ファイル内のファイルを閲覧する動作が正常に動作しない不具合修正
        * ソートにて、ファイル属性グループをオフできるように変更
    * 1.6.1
        * アイコン読み込み用の並列処理の見直し
        * ファイル・フォルダーの削除失敗時、失敗理由も表示するように変更
        * ランチャーなどでマクロを2個以上していると正常動作しない不具合修正
        * 「ファイルのタイムスタンプ変更」でサブフォルダー以下も反映できるように変更
    * 1.6.0
        * スペースを含むフォルダーで「新規Zero起動」が正常に動作しない不具合修正
        * 起動時の表示範囲をマルチモニターの範囲に再度修正
        * ファイルが多いフォルダーでのファイル窓の横スクロールを高速化
        * 終了関連メニューの追加(ログオフ、シャットダウン含む)
        * 設定の操作性改善(Tabキーで選択される項目の順番など)
        * 「自己展開ファイルに変換」を追加
        * ファイル窓での右クリックメニューをキャンセルした時、前回実施の処理が実行される不具合修正
    * 1.5.7
        * 圧縮窓などでEnter時に関連付けアプリが起動しない不具合修正(1.5.5のバグ)
        * 設定の操作性改善(圧縮・展開設定、キー設定、内蔵テキストビュワー設定)
    * 1.5.6
        * 「ドライブ変更」の不具合修正 ＆ ドライブリスト表示改善
        * 「ランチャー設定」or「ジャンプ設定」の階層化入力の改善
        * 「ランチャー設定」(Launcher.json)のデフォルトアプリのショートカット変更
    * 1.5.5
        * 起動時の表示範囲をマルチモニターの範囲に修正
        * Enter時、関連付けされているファイルに対する動作をOS(シェル)に任せるように変更
        * Enterで、適切なアプリが見つからなかった時、デフォルトビュワーを実行するように変更
        * Shift+Enterで、適切なアプリが見つからなかった時、デフォルトエディタを実行するように変更
    * 1.5.4
        * ネットワーク先のフォルダーへのコピー速度が遅い課題を修正(1.0.3以降の問題)
        * ドライブ変更時に、元のフォルダーをフォルダー履歴に残すように変更
    * 1.5.3
        * 「基本設定」→「一般」→「前回終了状態の複数窓を復帰」の動作改善
        * 「Zero 一覧」で "DEL"キーにて不要な Zeroを終了できるように変更
    * 1.5.2
        * 「基本設定」→「一般」→「前回終了状態の複数窓を復帰」の動作不具合を修正(64bit版のみ)
    * 1.5.1
        * 「カラー設定」ファイル窓などの「背景」の色設定が反映されない不具合修正
    * 1.5.0
        * 「ワイルドカードでマーク」を追加
        * 「カラー設定」に拡張子別カラー設定を追加(Color.jsonも変更)
        * 「設定」→「基本設定」→「一般」の「ファイル追加情報設定」で"2"の属性(12文字)を選択時、Link フォルダーでエラーとなる不具合修正
        * 「設定」→「基本設定」→「一般」の「フォルダー毎にカーソル位置を記憶」を追加
    * 1.4.1
        * 「ランチャー設定」「ジャンプ設定」(ZeroConfig)での「グループ追加」の動作不具合修正
        *  ディスクの使用量をカラーバーで表示するように変更
        * 「設定」→「拡張子対応設定」の「*」の初期設定からShift+Enter以外の項目を削除
    * 1.4.0
        * 「ランチャー設定」「ジャンプ設定」(ZeroConfig)での「グループ追加」などの動作改善
        * リスト窓に表示されるファイル数が1画面未満のとき、ScrollBarを触るとその後範囲外エラーが発生する不具合修正
        * ネットワークフォルダーでZeroを終了し、再度起動すると表示が真っ黒になる不具合修正
        * LZH形式用のDLLとしてLhaZero64.dll/LhaZero32.dllを追加
    * 1.3.1
        * USB経由のスマホに対して「名前変更」対応
        * USB経由のスマホに対して「指定フォルダー(ディレクトリ)へ」対応
        * USB経由のスマホに対して「コピー」「ファイル移動」強化
        * USB経由のスマホに対して「閲覧」などの操作は、テンポラリフォルダで行うこととした
    * 1.3.0
        * USB経由で接続されたスマホのフォルダー操作に対応
        * Zero(32bit)のコンパイラーをDelphi10.3.3に変更
        * 「ドライブ変更」でUSB経由に接続されたスマホなどが表示されるように変更
    * 1.2.2
        * フォルダー変更時の動作改善
        * Zv(0.03):10%ずつの拡大、縮小機能の追加
        * Zv(0.03):圧縮、縮小アルゴリズムを、ハーフトーン法から、GDI+の高品質バイキュービック法に変更
    * 1.2.1
        * Zv(0.02)：Ctrl+矢印の動作を追加
        * Zv(0.02)：編集、閲覧動作を追加(Zeroの拡張子対応設定と共通)
        * Zv(0.02)：「次の画像」、「前の画像」を追加
        * ZeroConfig(64bit)で、圧縮・展開用DLLのラベル表示が間違っていたのを修正
        * 「ファイル移動」でのエラー発生時の中断処理を強化
    * 1.2.0
        * 簡易画像ビュワー(Zv.exe)追加
        * 各窓終了およびフォルダー変更時、不正アドレスにアクセスするときがある不具合修正
        * ZeroConfigの拡張子対応設定で、「…」釦が効かないのを修正
        * マークファイル削除で、ファイルが削除できないとき、マーク処理を中断できるようにした
    * 1.1.3
        * 内蔵テキストビュワーのメモリーリーク修正
        * 圧縮窓(圧縮ファイル直視モード)のメモリーリーク修正
        * 他のソフトによりカレントフォルダー情報が更新されたとき、表示が更新されない場合がある不具合修正
        * ファイル更新時の再表示でのメモリーリーク修正
    * 1.1.2
        * 操作性改善のため、ZeroConfigの更新釦削除
        * あいまいインクリメンタルサーチの反転描画の不具合修正
    * 1.1.1
        * 情報パネルの表示で列数を増やしたとき、ロングファイル名が途中でカットされる不具合修正
        * あいまいインクリメンタルサーチで"ro"などがヒットしないなどの不具合修正
        * ZeroConfigでver1.1.0の新規項目の設定が保存されない不具合修正
        * ZeroConfigの「あいまい用辞書フォルダー」でフォルダーが選択できない不具合修正
    * 1.1.0
        * 内蔵テキストビュワーに、簡易バイナリ表示機能を追加
        * あいまいインクリメンタルサーチ追加(別途 migemo必要)
        * インクリメンタルサーチの選択表示不具合修正
        * 情報パネルの表示をカスタム可能にした(情報パネルの表示設定、ファイル追加情報設定)
        * マクロ $z(Zeroのフォルダー)の展開で、末尾に'\'が含まれているのを削除
        * DelZipWrap.dllによる Zipファイル操作時の窓のスタイルをZero本体に合わせる
    * 1.0.8
        * 複数ファイルのコピー先に同一ファイル名がある場合、名前の自動連番機能が正しく動作しない不具合修正
        * 内蔵テキストビュワーも、Alt+Tabのタスク切替で、切り替えれるように変更
    * 1.0.7
        * 内蔵ビュワーの「編集」にShift+Enterを割り当て
        * 「新規ファイル編集」でのファイル名入力ダイアログのタイトル修正
        * ZeroConfigの設定項目が空の場合、新規項目が追加できない不具合修正
        * 一部の設定ファイルの読み込み、書き込み忘れ修正(ZeroConfig)
        * ジャンプ設定にて、タイトル入力を省略し更新釦を押した際、ツリー表示の項目名が空になる不具合修正
        * コピー時などの、新規フォルダー作成確認のデフォルト釦を設定できるように変更
        * マークファイルのコピー中断時、マークファイルすべて中断するように修正
        * 「コピー」、「名前変更」などの自動連番機能の動作を改善
    * 1.0.6
        * (64bit版)Pack.json 64bit用DLLに修正
        * (64bit版)UNBYPASS.DLLに対応
        * (64bit版)コピー時など「動作中のZero」が一部しか表示されない不具合修正(1.0.3のバグ)
    * 1.0.5
        * ネットワークドライブへのファイル移動が失敗する不具合修正
        * ファイルパスが長い場合、移動ができない不具合修正
        * ZeroConfig起動時に、一部の領域が描画されない場合がある不具合修正
    * 1.0.4
        * 「参照してコピー」「参照して移動」でフォルダー履歴が残らない不具合修正
        * 1つのZeroがハングすると他のZeroもハングする不具合修正(タイムアウト追加)
    * 1.0.3
        * コピー、移動処理改善(処理中のGUIのレスポンス改善、中断処理改善、残り時間の計算方法改善)
        * 「指定フォルダーへ」にて他のZeroのリスト表示が増えていく不具合修正
        * リスト窓, 圧縮窓, 参照窓のワイルドカード動作を修正
        * 「ファイル検索」で、"."ファルダーがヒットする場合がある不具合を修正
    * 1.0.2
        * ポップアップメニューをOS準拠とカスタムスタイルから選択できるように変更(OS準拠は、アクセラレータキーの重複が可能)
        * 内蔵テキストビュワーの「編集」で実行されるデフォルトエディタを「基本設定」の「デフォルトエディタ」に修正
    * 1.0.1
        * 64bit版のみ、ライセンスキー登録を追加
        * Outlookの添付ファイルなどの仮想ファイルをドロップした際、確認せずに上書きする不具合修正
        * ZeroConfigの「基本設定」のツリー上の項目をキーボードで選択できない不具合を修正
        * ZeroConfigの「ドライブバー表示」の設定が、ON/OFF反対なのを修正
        * ZeroConfig：「拡張子対応設定」(Ext.json)に対応
        * ZeroConfig：「圧縮・展開設定」(Pack.json)に対応
        * ZeroConfig：「ネットワーク接続先設定」(Network.json)に対応
        * ZeroConfig：「カラー設定」(Color.json)に対応
        * ZeroConfig：「キー設定」(Key.json)に対応
        * ZeroConfig：「内蔵テキストビュワー設定」(Key.json)に対応
    * 1.0.0
        * 正規表現ライブラリをSkRegExpに変更
        * フォントサイズが大きいとき「並び替え」で文字が見えない不具合修正
        * ファイル窓と参照窓が管理する各ドライブのカレントフォルダーを同期するように修正
        * 複数ファイル選択時の「属性変更」の動作を修正
        * 「画面リフレッシュ」を参照窓に実装
    * 0.9.9
        * Outlookなどの添付ファイルもドロップできるように修正
        * Font設定により各小窓の文字が一部欠ける不具合を修正
        * メモリナンバージャンプリスト修正・機能追加
        * アクティブになったときの再描画処理(0.9.6)でメモリ不足に陥る不具合を修正
    * 0.9.8
        * 参照窓、リスト窓に窓切替系のコマンド追加
        * 参照窓と閉じた際に、ファイルリストを最新情報に自動更新するように修正
        * ネットワーク窓でのネットワーク接続先設定表示を改善
        * Iconのメモリーリークを修正
        * Zero.jsonの"Common"の"FontSize"の設定を各小窓へ反映するように変更
        * ファイル上書の窓位置を、マウス位置の横に表示するように修正
    * 0.9.7
        * ネットワーク窓でのネットワーク接続先設定表示を改善
        * ネットワーク窓のコンピュータ一覧取得方法を切り替えれるように変更(NetListMoe)
        * ネットワーク窓の窓サイズを記憶するように修正
        * Shift+ドラッグ＆ドロップでファイル移動できるように変更
        * メモリナンバージャンプに登録時、誤操作防止として確認メッセージを表示するように変更
    * 0.9.6
        * '/', '^'のキー割り当てができない不具合修正
        * 黒画面対策として、アクティブになったとき、再描画するように変更
        * 参照のネスト動作が正常に動作しない不具合修正
        * 参照してコピー、移動を実装
        * ネットワーク窓に、ネットワーク接続先設定の内容を反映するように変更
    * 0.9.5
        * 参照窓のドライブバー表示の高速化
        * 高DPIモニタ環境で、キャンセル釦などの字がはみ出る問題を修正(字が小さくなります)
        * 「ゴミ箱へ」の削除後、他のアプリにフォーカスが移動する不具合を修正
        * ファイル名が長い場合、情報欄の時間などの情報と文字が重なる不具合を修正
        * キーカスタマイズ機能追加
    * 0.9.4
        * ネットワーク窓の動作安定化・強化
        * ドライブバーにネットワークドライブ(ネットワーク窓)用の釦を追加
        * フォルダーコピーで属性がコピーできていない不具合修正
        * 表示フォルダーと、実際のフォルダーにずれが発生する不具合を暫定修正
    * 0.9.3
        * 名前変更や、削除する際にカーソル位置が 親フォルダー(<..>)の場合、たとえマークファイルがあっても、実行が中断される不具合修正
        * 初回起動時、前回終了時と同じ窓数を復帰する機能をOFFにする設定("MultipleStart": false)を追加
        * タイムスタンプ変更機能追加
        * ネットワーク窓のアイコン表示を強化
        * ドライブバーON時に、参照窓にもドライブバーを表示するように変更
    * 0.9.2
        * 高DPIモニタでのドライブバーのサイズを修正
        * ネットワーク窓にて、コンピュータの中の共有フォルダー一覧に<..>を追加
        * 名前の大文字、小文字変更を追加
        * 起動初期のファイルのソート条件を固定化できるように変更(Zero.json)
        * 圧縮ファイル名にスペースが含まれている場合、中のファイルを参照できない場合がある不具合を修正
    * 0.9.1
        * 起動オプション指定時は、Zeroの自動複数起動をオフにする
        * Path入力時の初期値の設定"InputPathType"に、ジャンプ(設定値: 2)を実装
    * 0.9.0
        * マウスの戻る、進む釦に対応
        * キーによる最大化、最小化機能を実装
        * ランチャー設定、拡張子対応設定の「実行ファイル」項目でもマクロを使用可能に変更
        * 拡張子対応設定ファイル(Ext.json)の初期設定に"lnk"ファイルの項目を追記
        * 圧縮ファイル窓にポップアップメニューを実装
        * ポップアップメニューのスタイルを ダークモードに変更
        * 「ネットワークドライブ(ネットワーク窓)」を追加
        * ファイルコピーで属性がコピーできていない不具合修正
        * 接続が切断されたドライブのカレントフォルダー履歴を削除するように修正
        * 起動オプションを追加(直接ファイル名 or フォルダー, /F, /D)
        * システムファイル、隠しファイルの表示/非表示設定(ViewSysFile, ViewHidden)を追加
        * ドライブバーのカスタマイズ項目強化
    * 0.8.5
        * 不要なファイル属性取得処理を削除し高速化
        * スレッド処理の影響でフォルダー変更が上手くいかない場合がある不具合を修正
    * 0.8.4
        * 削除処理を中断すると削除できない旨のメッセージが複数回出る不具合を修正
        * ファイル窓、リスト窓のScrollバー動作改善
        * DelZipWrap.dllの進行状況(展開、圧縮)を表示するように変更
        * 高DPIモニタの動作を改善
    * 0.8.3
        * 「全ファイルマーク」「全マーク反転」「全ファイルマーク反転」を追加
        * ファイル検索時、無応答時間が長すぎるのを改善
        * PageDown動作/Scroll動作改善
        * ファイル検索の日付指定コンポーネント変更
        * 参照窓から戻ってきたとき、カレントフォルダーが、見えているフォルダーとずれる不具合を修正
    * 0.8.2
        * 圧縮ファイルなど新規ファイルを作成すると、メモリを二重に解放する不具合の修正
    * 0.8.1
        * 拡張子別のEnter時の動作が未定義の場合、OS準拠のアプリでの起動が優先されない不具合修正
        * Zero.jsonの"Loop"設定(false, true)を廃止し、"LoopType"設定(0,1,2)に変更
    * 0.8.0
        * Iconの内部管理方法を大きく変更(0.1.xに近い方式に戻す)し、動作速度改善
        * Ctrl+Vによる貼り付けの動作不良を修正
        * ファイルへのハイパーリンクをクリップボードへコピーする機能(Shift+B)追加
        * 内蔵テキストビュワーの右クリックメニューを実装(以前はモジュールのデフォルトメニュー)
        * 内蔵テキストビュワーの設定を TextView.jsonに移動
        * 内蔵テキストビュワーで、TAB幅を切り替えられるように変更
        * 「戻る」、「進む」を実装
    * 0.7.1
        * Shift-F10によるコンテキストメニュー表示の際、終了メニューが出る不具合修正
        * 添付ファイルや、(エクスプローラーなどから)圧縮ファイルの中身のファイルをドロップできるように修正
        * 起動時、前回終了時のフォルダーが見つからない場合、環境変数HOMEDRIVEのルートで起動するように修正
        * 複数ファイルコピーにおいて、同名のファイル名があったときの自動生成に不具合があったのを修正
        * 「実行」時、手動でパラメータを追記すると コマンドが実行出来ない不具合を修正
        * Ctrl+右の動作を、最終ファイル位置ではなく、右端のファイル位置への移動に変更
        * 参照窓の右下に空き容量表示を追加
        * ヘルプに設定メモ(memo.txt)を開くメニューを追加
        * 内蔵テキストビュワー用モジュールScintillaを5.0.0に更新
    * 0.7.0
        * Iconのメモリーリークを修正
        * コピーの進捗画面に表示される空き容量が間違っていたのを修正
        * フッター情報欄(FooterTypeで指定)を追加
        * フォルダーをドロップされたときに、中身がコピーできない不具合を修正
        * 複数ファイルの名前変更で、連番機能を追加
        * ファイルサイズ、日付、属性などの各表示項目のマージン設定を追加
    * 0.6.4
        * リスト窓でファイル数が 0になったときの不具合を修正
        * MemoryNumJump機能の一覧表示GUIで、テンキーが使えない不具合修正
    * 0.6.3
        * 内蔵テキストビュワーにジャンプ(指定行へのジャンプ)機能実装
        * 同名ファイルのコピー処理で、「既存ファイル名を変更」が失敗する不具合を修正
        * 同名ファイルのコピー処理で、手動入力したファイル名が既にあるときの処理を修正
        * Win10 64bit環境で使用できるメモリーを拡張。32bit環境は変わらず
        * MemoryNumJump機能の一覧表示GUIを強化
    * 0.6.2
        * フォルダー、リードオンリーなどのファイル削除の初期設定項目を追加(Zero.json)
        * フォルダー、リードオンリーなどのファイル削除確認の見た目を変更
        * 圧縮・展開設定(Pack.json)に定義されているDLLが見つからない場合、ハングアップする不具合修正
        * 確認、エラーなどのダイアログをZeroと同様のスタイルに変更
        * カレントフォルダーを履歴に追加(Ctrl+H)を実装
        * 内蔵テキストビュワーの行番号の表示幅を計算で求めるように修正
        * MemoryNumJump機能の追加
        * 水平スクロールバーの表示を見直し
    * 0.6.1
        * 内蔵テキストビュワーの検索でヒットした文字列の色を白→黄色に変更
        * 内蔵テキストビュワーの検索でヒットした文字列の位置に画面をスクロールするように修正
        * 内蔵テキストビュワーでフォーカスが無いときPgUp/PgDnキーが効かないのを修正
        * ファイルをドロップしたときのコピーに失敗する不具合を修正(0.5.6からの不具合)
        * ファイル検索で、フォルダー名を含むか否かのチェック状態を記憶するように変更
    * 0.6.0
        * uで始まるフォルダー名でZeroを終了するとエラーとなる不具合修正
        * 内蔵テキストビュワーの心臓部をTEditorからScintillaに変更(Unicode12.0ぐらいまでの絵文字に対応)
        * Unzin32.dllによる個別ファイル展開が動作しない不具合を修正
        * フォルダー、リードオンリーなどのファイルを削除するとき確認をとるように変更
        * 削除失敗時に、メッセージを表示するように変更
        * 「ファイル名をクリップボードへ」実行時、内容表示をするように変更
    * 0.5.7
        * 拡張子対応設定に該当しないファイルでのEnter動作を改善
        * ファイルの検索条件に、フォルダー名も対象に含むオプションを追加
        * ランチャー設定や拡張子対応設定の、実行フォルダー指定が動作していない不具合修正
        * 「圧縮コマンド」、「展開コマンド」編集結果が反映されない不具合修正
        * 圧縮ファイル参照時、フォルダー内のファイルの展開が動作しない不具合修正
    * 0.5.6
        * 圧縮ファイル参照時、<..>をダブルクリックで参照を終了するとエラーが発生する不具合修正
        * 圧縮ファイル参照時、Enterでもファイル参照動作(拡張子別の動作)ができるように変更
        * ファイルの検索条件に、期間の設定を可能に変更
        * リスト窓でのコピー、移動、削除処理の不具合修正
    * 0.5.5
        * ネットワークドライブパスを内部で強制的にUNC形式に変換し取り扱っていたが、オリジナルの状態を維持するように変更
    * 0.5.4
        * Zipファイル用ラッパーDLL(DelZipWrap)不具合修正
        * 窓の幅がカーソル幅(ファイル情報表示幅)より小さい場合、動作しない不具合を修正
        * ランチャーでコマンドにファイル名を渡す場合、不要な場合は「"」で囲まないように変更
    * 0.5.3
        * オプションで使用可能なマクロの$F, $fがフルパスになってない不具合を修正
        * 「ファイル名をクリップボードへ」にショートカットキーを割り当て
    * 0.5.2
        * カーソル位置が".."の場合、マーク済みのファイルがあっても削除できない不具合を修正
        * Loop=true設定時、末尾のファイルを選択すると全体のファイル選択状況が反転する不具合修正
        * ファイルサイズ処理で 32bitで扱っていた部分を修正
        * Zero.jsonの"Common"の"FontSize"の設定で、参照窓などの釦や上の情報欄の表示が大きく崩れる不具合を修正
        * Path入力時の初期値の設定"InputPathType"を実装
        * ファイル検索結果の画面(リスト窓)に「ファイル移動」を実装
        * ファイル検索結果の画面(リスト窓)で「Number Jump」が動作する不具合修正
    * 0.5.1
        * 基本設定(Zero.json)の"Edit", "View"項目が無効になっていたのを修正
        * 新規ファイル編集(Ctrl+E)を実装
        * 圧縮ファイル参照時、X, Ctrl-Pの動作を禁止に修正
    * 0.5.0
        * 基本設定ファイルをZero.iniから、Zero.jsonに変更
        * Zero.jsonにて、窓毎の表示詳細設定を実装(ファイルサイズ、日付などの表示形式)
        * カーソルが、先頭-末尾間を移動できる設定(Loop = true)を追加
        * 参照窓に色設定が反映されない不具合修正
        * 圧縮ファイル参照時、対応するアーカイバライブラリ(DLL)がない場合、動作が不安定になる不具合修正
    * 0.4.5
        * 内蔵テキストビュワーの文字コード判定(BOMなしのUTF-16, UTF-8)を改善
        * 「圧縮コマンド」、「展開コマンド」実装
        * 圧縮、展開で複数ファイルを扱うときは、リストファイルを用いて処理するように変更
        * Zipファイル用ラッパーDLL(DelZipWrap)のリストファイル対応
        * 並び替え(ソート)の降順で、属性グループの順番が変わってしまう不具合修正
    * 0.4.4
        * マークファイル情報を表示するように変更
        * 最大表示ファイル長の設定を実装
        * 設定ファイル編集用のエディタ(LauncherEditor, JumpEditor)が実行されない不具合修正
        * フォルダー単体の圧縮が上手く行かない不具合修正
        * リソース不足対応のためアイコン取得の上限を500に設定
    * 0.4.3
        * 内蔵テキストビュワーの文字コード判定(UTF-16 BOMなし)を改善
        * <..>のアイコンを自フォルダーアイコンに変更
    * 0.4.2
        * Jumpメニューのタイトル省略時、移動先フォルダーがタイトルになるが環境変数を展開するように修正
        * 内蔵テキストビュワーの文字コード判定を修正
        * 内蔵テキストビュワーの文字コード判定結果をステータスバーに表示
        * 内蔵テキストビュワーの文字コード強制切替実装
    * 0.4.1
        * 内蔵テキストビュワーの設定保存先を、configフォルダーに修正
        * 内蔵テキストビュワーの「ファイル」→「開く...」を実装
        * 内蔵テキストビュワーの「実行」→「編集」が動作しない不具合修正
        * 圧縮ファイル参照時のアイコンが適切ではなかったのを修正(参照時は拡張子別のアイコンしか表示できません)
    * 0.4.0
        * Dir欄の表示フォルダーをクリックすることでフォルダー変更を可能にした
        * Dir欄の空きスペースをダブルクリックすることで指定フォルダーに移動(移動先フォルダー窓呼び出し)可能に変更
        * ファイル操作画面に遷移した際、自動でIMEオフにするように変更
        * フォルダー変更失敗時の処理を修正
        * 参照窓で数字キーによるドライブ切替ができない不具合修正
        * 内蔵テキストビュワー追加(コマンド名は、@viewで指定可能)
    * 0.3.7
        * 表示中のフォルダー内のファイルリストが更新されるとハングする不具合修正(0.3.5が原因)
    * 0.3.6
        * フォルダー移動時にハングする不具合修正(0.3.5が原因)
        * ファイル移動時にハングする不具合修正(0.3.5が原因)
        * フォルダー選択で、ファイル選択直後にハングする不具合修正(0.3.5が原因)
    * 0.3.5
        * Homeボタンでの全ファイルマーク時、".."をマークしてしまう不具合修正
        * フォルダー変更時の操作性改善
        * 拡張子別のIcon管理不具合修正
    * 0.3.4
        * Drag&Dropコンポーネントの変更
        * フォーカスが来たとき再描画するように修正(改善)
        * 圧縮ファイルを参照後、展開動作でメモリのアクセス違反が発生する不具合の修正
        * 圧縮ファイル参照時、フォルダーがリストの先頭に来ないことがある不具合を修正
        * ドライブバーを追加
    * 0.3.3
        * ファイル検索時の進捗表示が正常に行われない不具合を修正
        * 削除時の進行状況を表示するように変更(削除処理を自前処理に変更)
        * モニタを切り替えに対応(Per-Moitor V2)
        * 複数のZeroを同時終了するとハングする不具合修正
        * フォーカスが来たとき再描画するように修正
        * 「新たに別のZeroを起動」時に、表示位置をずらし、現在フォルダーで起動するように修正
        * Windows終了時のZeroの窓状態を復帰
        * 起動直後のFile欄が空白となっているのを修正
    * 0.3.2
        * インクリメンタルサーチ時に、数字キーを押すとドライブが切り替わる不具合修正
    * 0.3.1
        * ZIP32J.DLLに対応できていなかったのを修正
        * 移動先フォルダーの窓で、フォルダーを入力してある状態で、「参照」釦を押した際は、そこを基準に参照窓を開くように変更
        * Dragが出来なくなる不具合を修正
        * ワイルドカード指定で表示を絞っている状態で「全ファイルマーク」をすると動作がおかしかったのを修正
        * 数字キーでドライブ切替する機能を追加
    * 0.3.0
        * 圧縮ファイル直視モードを追加（展開せずに中身を確認する機能）
        * DelZipWrap機能追加（フォルダーなし展開オプション "e" の追加, OpenArchive 系 APIを部分的に追加）
        * UNLHA32.DLL以外の統合アーカイバプロジェクトDLLが動作しない不具合修正（中国語などの文字も取り扱いできます）
        * カラー設定ができる機能を追加
    * 0.2.0  
        * Iconの内部管理方法を大きく変更
        * Icon表示途中のキーボード操作性改善
        * 検索ファイルが見つからないとき、その後操作不能になる不具合修正
        * 更新したファイルのIconが消えるのを修正
        * jsonファイルの不正時のエラー表示を強化
    * 0.1.2  
        * Moveコマンドによるフォルダー移動時に元のフォルダーが削除されない不具合を修正
        * 検索ファイルが見つからないときはメッセージ表示のみとし、
          結果のリスト表示を行わないように変更
        * ワイルドカード指定で 拡張子の ".*" 指定が上手く動作しない不具合修正
        * コピー/移動の上書き確認で、"以降設定"を同設定にしても、
          各ファイルに対してファイル名の問い合わせが発生する不具合を修正
    * 0.1.1  
        * ファイル検索結果の画面でのコンテキストメニュー(右クリックメニュー)表示の修正
        * ファイル検索結果の画面でファイルの編集や、表示ができない不具合を修正
        * ドライブ変更時、Network.jsonが無いとエラー表示される不具合を修正
    * 0.1.0  
        * 拡張子対応機能を追加
        * オプションで使用可能なマクロを割り当てを一部変更
        * ルートのファイルがドラッグできない不具合を修正
        * Jump.json, Launcher.jsonの書式を変更 ★注意:旧書式との互換性がありません★
    * 0.0.7  
        * 「属性変更」追加
        * マウス操作によるコンテキストメニュー表示を改善
        * コンテキストメニューの「名前の変更」処理を修正
        * ファイル検索の結果画面でBSキーなどを押すと、フォルダーが変わってしまう不具合修正
    * 0.0.6  
        * Unzip32.dllなど、Unicodeに非対応のDLLでの動作が不正であったのを修正
    * 0.0.5  
        * 圧縮・展開機能追加(統合アーカイバプロジェクトのDLLをサポート)
        * 基本設定を書き換えても、Zero終了時に元に戻してしまう不具合修正
        * 検索結果のファイル名の表示可能文字数を増やした
        * フォルダー選択窓で、ドライブ変更('L')ができない不具合を修正
        * フォルダー選択窓の、Dir欄をまともに編集できない不具合を修正        
    * 0.0.4  
        * フォルダーや、コマンド指定時に、環境変数が使用可能に変更
        * Configフォルダーが無いとき、起動エラーが出る不具合修正
        * 「フォルダー作成」と、「指定フォルダー(ディレクトリ)へ」の履歴を統一
    * 0.0.3  
        * "エクスプローラー処理"を追加(コピー、切り取りなど)
        * クリップボードへのファイル名のコピーなどを追加
        * フォルダーの変更監視が止まってしまう不具合修正
    * 0.0.2  
        * readme.mdの不備を加筆
        * 移動先フォルダー窓 → フォルダー選択画面 →さらに移動先フォルダー窓を
          開くと内部のアドレス異常が発生する不具合を修正
    * 0.0.1: 初版 (Test版除く)  - 2019.10.22  
        * 令和元年記念として、リリース。
