//
//  ASForm.h
//  ASForm
//
//  Created by 佐藤 昭 on 2014/06/21.
//  Copyright (c) 2014年 SatoAkira. All rights reserved.
//

#import <Cocoa/Cocoa.h>

//! Project version number for ASForm.
FOUNDATION_EXPORT double ASFormVersionNumber;

//! Project version string for ASForm.
FOUNDATION_EXPORT const unsigned char ASFormVersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <ASForm/PublicHeader.h>
// NSFormがOSX10.10でdeprecatedになったので作ったNSViewのサブクラス。NSFormのようにNSMatrixのサブクラスとすることはできない。NSMatrixだと横に並んだオブジェクトのサイズが同じになってしまう。InterfaceBuilderでCustomViewを配置して、Custom Class->ClassをASFormにする。IBOutletはASFormのインスタンスとする。必ず2つずつのNSControlで構成させる。NSControlのサブクラスNSTextFieldが一般的である。InterfaceBuilderで各々のNSControlに、0起点とし重複が無く連番となるtagを必ず設定する。偶数のtagが設定されたNSControlがTitleとなり、奇数のtagが設定されたNSControlがTextとなる。各メソッドで与えるindexはtagではなくてtag/2 の値である。selectedRowはテキスト側のtag/2。 //
// xibファイルのUse Auto LayoutはONでもOFFでもどちらでも良い。 //
// calcSizeを実行した場合の注意点。タイトルについてはNSViewMinXMarginをOFFに、NSViewMaxXMarginをONに、NSViewWidthSizableをOFFに強制設定する。テキストについてはNSViewMinXMarginをONに、NSViewMaxXMarginをOFFに、NSViewWidthSizableをONにする。calcSizeを実行させる場合にはタイトルは左側、テキストは右側の方が良い。 //
// OS10.14のダークモードに対応させるためには、ASFormのAppearanceをInherited(System,DarkAqua)とし、Title側のTextColorをDefault(Label Color)とする。BackgroundはDefault(Text Background Color)とする。 //

@interface ASForm : NSView

- (void)calcSize;
- (NSControl *)cellAtIndex:(NSInteger)index; // Text側を返す。NSFormがNSFormCellを返すのと違ってText側のNSControlのサブクラスを返す。 //
- (NSControl *)titleAtIndex:(NSInteger)index; // Title側を返す //
- (void)selectTextAtIndex:(NSInteger)index;
- (void)setTextAlignment:(NSTextAlignment)mode; // NSFormの実装と同じですべてのテキストの行揃え方法を指定する。//
- (void)setTitleAlignment:(NSTextAlignment)mode; // NSFormの実装と同じですべてのタイトルの行揃え方法を指定する。//
- (NSInteger)indexOfSelectedItem;
- (void)setTitleFont:(NSFont *)fontObj; // NSFormの実装と同じですべてのタイトルのフォントを設定する。//
- (void)setTextFont:(NSFont *)fontObj; // NSFormの実装と同じですべてのテキストのフォントを設定する。//
- (NSUInteger)numberOfRows; // rowsなので行数すなわちindexの最大値+1を返す。 //
- (NSControl *)addEntry:(NSString *)title; // viewサイズは変更しない。追加したEntryのテキスト側のオブジェクトを返す。垂直位置調整はverticalCellSpacingの値でやってしまう。現在のところスペース設定はできない。タイトルの最大長の変化による水平位置調整未完成。InterfaceBuilderで追加分のサイズまで確保しておく必要がある。タイトル、テキストは最低1個ずつ必要。エラーチェック無し。 //
- (void)removeEntryAtIndex:(NSInteger)index; // viewサイズは変更しない。indexより下の位置調整未完成。タイトルの最大長の変化による位置調整未完成。現在のところ最下段のみremoveする。indexは現在のところ最下段を指定する。タイトル、テキストは最低2個ずつ必要。エラーチェック無し。 //

/* + (NSClass)cellClass;
+ (void)setCellClass;
- (void)setEntryWidth:(CGFloat)width;
- (void)setInterLineSpacing:(CGFloat)spacing;
- (void)setBordered:(BOOL)flag;
- (void)setBezeled:(BOOL)flag;
- (void)drawCellAtIndex:(NSInteger)index;
- (NSFormCell *)insertEntry:(NSString *)title atIndex:(NSInteger)index;
- (NSInteger)indexOfCellWithTag:(NSInteger)tag;
- (void)setFrameSize:(NSSize)newSize;
- (void)setTitleBaseWritingDirection:(NSWritingDirection)writingDirection;
- (void)setTextBaseWritingDirection:(NSWritingDirection)writingDirection;
- (void)setPreferredTextFieldWidth:(CGFloat)preferredWidth;
- (CGFloat)preferredTextFieldWidth; */ // 実装する予定無し //
/* - (NSAttributedString *)attributedTitle;
- (id)initTextCell:(NSString *)aString;
- (BOOL)isOpaque;
- (void)setAttributedTitle:(NSAttributedString *)attributedTitle;
- (void)setTitle:(NSString *)aString;
- (void)setTitleWidth:(CGFloat)width;
- (NSTextAlignment)titleAlignment;
- (NSInteger)selectedRow; */ // その他NSFormCellのメソッドは実装する予定無し。 //

@end


