//
//  ASScienceLibrary.h
//  Geolient
//
//  Created by 佐藤 昭 on  08/01/03.
//  Copyright 2008 SatoAkira. All rights reserved.
//

/* #if TARGET_OS_IPHONE
#import <Foundation/Foundation.h>
#else */
#import <Cocoa/Cocoa.h>
/* #endif */


@interface ASScienceLibrary : NSObject

#ifndef M_PI
#define M_E         2.71828182845904523536028747135266250   /* e */
#define M_LOG2E     1.44269504088896340735992468100189214   /* log_2(e) */
#define M_LOG10E    0.434294481903251827651128918916605082  /* log_10(e) */
#define M_LN2       0.693147180559945309417232121458176568  /* log_e(2) */
#define M_LN10      2.30258509299404568401799145468436421   /* log_e(10) */
#define M_PI        3.14159265358979323846264338327950288   /* pi */
#define M_PI_2      1.57079632679489661923132169163975144   /* pi/2 */
#define M_PI_4      0.785398163397448309615660845819875721  /* pi/4 */
#define M_1_PI      0.318309886183790671537767526745028724  /* 1/pi */
#define M_2_PI      0.636619772367581343075535053490057448  /* 2/pi */
#define M_2_SQRTPI  1.12837916709551257389615890312154517   /* 2/sqrt(pi) */
#define M_SQRT2     1.41421356237309504880168872420969808   /* sqrt(2) */
#define M_SQRT1_2   0.707106781186547524400844362104849039  /* 1/sqrt(2) */
#endif

#define LOW 206264.806247096377
#define RADIUSOFBESSEL 6377397.155 // ベッセル楕円体の赤道半径 //
#define RADIUSOFBESSELSTRINGS @"6377397.155"
#define FLATRATIOOFBESSEL 299.1528128 // ベッセル楕円体の扁平率の逆数 //
#define RADIUSOFWGS84 6378137.0 // WGS-84の長半径 //
#define FLATRATIOOFWGS84 298.2572235630 // WGS-84の扁平率の逆数 //
#define RADIUSOFGRS80 6378137.00	// GRS80の長半径 //
#define FLATRATIOOFGRS80 298.257222101	// GRS80の扁平率の逆数 //
#define APPLOXIMATERADIUSOFGLOBE 6370000.0 // 概算曲率半径。測地系に無関係に使える。 //
#define GPSPARAMETERSTYLE 3	// 0:「国土地理院数値地図5kmメッシュ(ジオイド高)」TokyoDatum -> WGS-84, 1:「建設省公共測量作業規程」1996年以前TokyoDatum -> WGS-84, 2:「建設省公共測量作業規程」1996年版による計算法TokyoDatum -> WGS-84, 3:「国土地理院」TokyoDatum<->ITRF94, 4:「国土地理院」WGS-84 -> ITRF94 未対応 //
#define JGEOID96FILENAME "jgeoid96.dat"
#define JGEOID96FILE @"jgeoid96.dat"
// #define GSIGEOMEFILENAME "gsigeome" //
#define GSIGEOMEFILE @"gsigeo" // hasprefix で判断する。 //
#define UNKNOWNGEOID 999.0
// tky2jgd...で使われるのが主である。 //
#define FROMPARAMETERSKEY @"FromParameter"
#define CONVERTDATAKEY @"ConvertData"
#define PARAMETERSKEY @"Parameters"
#define MESHCODEKEY @"MeshCode"
#define LATITUDEKEY @"Latitude"
#define LONGITUDEKEY @"Longitude"
#define ORTHOMETRICHEIGHTKEY @"OrthometricHeight"
#define SYSTEMKEY @"System"
#define AREAKEY @"Area"
#define TARGETKEY @"Target"
#define LOWERLEFTKEY @"LowerLeft"
#define LOWERRIGHTKEY @"LowerRight"
#define UPPERLEFTKEY @"UpperLeft"
#define UPPERRIGHTKEY @"UpperRight"
// tky2jgd... //

struct BLDATA { double bd,br,ld,lr,nd,nr,m; }; // nd,nr,rn,nなどは子午線収差角(meridian convergence)を表す。真北方向角の反対符号の値を持つ。m,scは縮尺係数を表す。計算式でm0とかmが使われるのでmを使用する。nd,nrは子午線収差角。mは縮尺係数。.m に準拠楕円体からの高さ、ndに準拠楕円体の長半径,blsp.nrに扁平率の逆数が使われることも有る。 //
struct HERMERT { double mcos,msin,c,d,sd,scale,t,aic,sda,pt,chi2; }; // 座標変換するには、mcos,msin,c,dの4つのデータで行う。X = mcos * x + msin * y + c; Y = mcos * y - msin * x + d; で新座標X,Yが求められる。sd:平均二乗誤差 scale:伸縮率 t:回転角のラジアン aic:AIC(赤池情報量標準)モデル検定値 sda:標準偏差 pt:t分布の両側確率に対するパーセント点 //
struct AFFINE { double a,b,c,d,e,f,sd,aic,sda,pt,chi2; }; // 座標変換するには、a,b,c,d,e,fの6つのデータで行う。X = a * x + b * y + c; Y = d * x + e * y + f; で新座標X,Yが求められる。sd:平均二乗誤差 aic:AIC(赤池情報量標準)モデル検定値 sda:標準偏差 pt:t分布の両側確率に対するパーセント点 //
struct XYZDATA { double x,y,z; };
struct CONVERTPARAMETER { double dx,dy,dz,sc,rx,ry,rz; NSInteger n; };
struct XYHDATA { double x,y,h,n,m; }; // 平面直角座標。x,yは座標値。hは楕円体高。nは子午線収差角。mは縮尺係数。 //
struct CONVERTDATA { double bd,br,ld,lr,wx,wy,gh,hGPS,axis,flat,gh_from,rn,sc; }; // bd,br,ld,lrは変換先でのBL。wx,wyは変換先での座標値。ghは変換先での準拠楕円体からのジオイド高さ。hGPSは変換先での準拠楕円体からの高さ。axis,flatは変換先での定数。gh_fromは変換元での準拠楕円体からのジオイド高さ。rnは変換先での子午線収差角。scは変換先での縮尺係数。 //
struct CONVERTCOUNTRYDATA { double wx,wy,wz,fromgh,fromaxis,fromflat,bd,br,ld,lr,nd,nr,x,y,z,gh,hGPS,axis,flat; }; // ghは変換元での準拠楕円体からのジオイド高さ。wx,wy,wzは変換元での座標値。axis,flatは変換元での定数。hは変換先でのジオイドからの高さ(即ち標高)。 //
struct TRIANGLE { double a,b,c,A,B,C,area,bottom,height; NSUInteger index0,index1; }; // A,B,Cは与えられたインデックスにおける夾角ラジアン。a,b,cはそれに対角に位置する辺の長さ。areaは面積。bottomは最長辺の長さ。heightはbottomからの高さ。index0,index1はbottomの頂点のインデックス。 //

typedef enum _ASDegreeUnit {
	UNunknown,
	UNradian,
	UNdegree,
	UNdms,
	UNsecond,
	UNhms
} ASDegreeUnit;

NSDictionary *get25kState(NSUInteger meshcode,NSString *dir);
NSRect getSecondMeshRect(NSUInteger meshcode,NSString *dir); // NSRectの構造:origin.x左下の緯度のラジアン,origin.y左下の経度のラジアン,size.width右上までのラジアン単位の緯度範囲,size.height右上までのラジアン単位の経度範囲。 //
NSString *orthometricHeightFullPath(NSUInteger meshcode,NSString *dir);
double orthometricHeight(double b,double l,NSString *dir); // 国土地理院数値地図50mメッシュ(標高)から標高データを検索する。記録されていないレコードがあった場合については、動作を確認していない。dir以下にファイルが無い場合、即ちfpがNULLのときはMAXFLOATを返す。海のときは-999.9を返す。 //
NSDictionary *getPatchJGD(NSArray *urlArray);
NSDictionary *makePatchJGDDictionary(NSURL *url);
NSArray *orthometricHeightFrom10m(NSArray *bl, NSURL *directoryURL, double *hMin, double *hMax); // 基盤地図情報(数値標高モデル)10mメッシュから標高データを検索する。directoryURLはnilを許さない。線形補間bilinear()をする。エラーが起きたときは[NSNumber numberWithDouble:MAXFLOAT]を要素とする配列を返す。海のときは[NSNumber numberWithDouble:-9999.0]を要素とする配列を返す。nilを返すことはない。hMinに最小値、hMaxに最大値が代入される。hMin,hMaxはMAXFLOATを除いた高さで決められるが、総ての点でエラーが発生するとそれぞれMAXFLOATと-MAXFLOATが代入される。blで指定された点の標高データが省略されている場合については[NSNumber numberWithDouble:MAXFLOAT]を配列の要素に与える。directoryURLに14.4MBの.plistファイルが作られるのでHDDの空き容量に注意する必要がある。GMLファイルのアップデートなどでGMLファイルを差し替えた場合には、該当する2次メッシュコードがファイル名に含まれている.plistファイルを削除してアップデートに対応する。patchJGDhには対応しない。必要な場合には別に、makePatchJGDhDictionary()でNSDictionaryを作っておいてからpatchJGDh()を呼び出す。DEM10Bの場合の精度は作成方法が地形図の等高線からなので標高精度(標準偏差)が5m以内とされている。 //
NSArray *orthometricHeightFrom5m(NSArray *bl, NSURL *directoryURL, double *hMin, double *hMax); // directoryURLはnilを許さない。線形補間bilinear()をする。海部と内水面についてはエラーではないが「データなし」と区別する方法がないので[NSNumber numberWithDouble:MAXFLOAT]を配列の要素に与える。内陸部で水面でないときに「データなし」の場合がある。この場合も内水面と区別する方法がないので[NSNumber numberWithDouble:MAXFLOAT]を配列の要素に与える。hMinに最小値、hMaxに最大値が代入される。hMin,hMaxはMAXFLOATを除いた高さで決められるが、総ての点でエラーが発生するとそれぞれMAXFLOATと-MAXFLOATが代入される。DEM5Aの場合の精度は作成方法が航空レーザー測量からなので標高精度(標準偏差)が0.3m以内とされている。DEM5Bの場合の精度は作成方法が写真測量からなので標高精度(標準偏差)が0.7m以内とされている。 //
double patchJGDh(double latitude, double longitude, NSDictionary *patchJGDDictionary);
NSDictionary *makeGeoidDictionary(NSURL *url);
double geoidalHeightUsingObject(double latitude, double longitude,NSURL *geoidFileURL, NSDictionary *geoidDictionary); // latitude, longitudeは計算する点の世界測地系における緯度・経度座標値(ラジアン)。補間したジオイド高を返す。旧バージョンのjgeoid96ファイルを使うときはlatitude,longitudeとしてWGS84を与える。XML形式のジオイドデータの場合は有効なgeoidDictionaryを指定し、geoidFileURLへ.xmlまたは.plistファイルの場所を指定する。geoidDictionaryはmakeGeoidDictionary()の戻り値を利用できる。XML形式以外ならばgeoidDictionaryはnilで良い。 //
struct XYHDATA getGeoidalHeight(double x,double y,NSInteger system,NSInteger area,NSURL *fileURL,NSDictionary *geoidDictionary); // 旧バージョンのjgeoid96ファイルを使うときはx,yとして旧日本測地系座標値、systemに旧日本測地系番号1841を与える。戻り値 .x:緯度のラジアン .y:経度のラジアン .h:ジオイド高 .n:子午線収差角のラジアン .m:縮尺係数 BL変換の際にエラーが発生すると.mが負の数となる。ジオイド高取得に失敗すると.hがUNKNOWNGEOIDとなる。.mはxytobl()の結果を使う。 //
struct XYZDATA patchJGDFromDictionary(double latitude, double longitude, NSDictionary *patchJGDDic); // .xは経度の秒単位、.yは緯度の秒単位、.zは標高。 //
NSArray *tky2jgdFromContents(NSInteger from,NSInteger to,NSInteger area,NSArray *tkyBL,NSString *contents,NSURL *geoidFileURL,NSDictionary *geoidDictionary,NSDictionary *patchJGDDic); // fromとtoは測地系番号。tkyBLは、緯度のラジアン・経度のラジアン・標高(m)を1組とする複数組の配列。contentsはパラメーターファイルのcontentsでnilとすることもできる。geoidFilenameはジオイドファイルの絶対パスでnilでも良い。NSDictionaryを要素とするNSArrayを返す。キーFROMPARAMETERSKEYのNSNumber:boolの値はパラメーターファイルを使用したか否か。キーCONVERTDATAKEYの値はstruct CONVERTDATA型のNSValue。エラーのときキーCONVERTDATAKEYの値はnil。jgd.wx jgd.wyは変換後の座標値、jgd.wzは子午線収差角（ラジアン）。jgd.ghはgeoidFilenameから検索した変換先での準拠楕円体からのジオイド高。jgd.gh_fromは変換元でのジオイド高。地域毎のパラメーターファイルfilenameから計算できたときはjgd.axisは緯度差、jgd.flatは経度差になる。これはパラメータファイルから計算したため、楕円体の常数を必要としなかったことを意味している。3パラメーターになったときは、jgd.axis jgd.flatは準拠楕円体の長半径と扁平率の逆数。jgdからtkyへの逆変換は地域毎のパラメーターファイルを使って最初に-12秒,+12秒してtkyを仮に設定してtkyからjgdへ変換し、変換結果ともとのjgdとを比較して誤差が少なくなる(1e-15)までのシュミレートをする。threeParameter()へのstyleはGPSPARAMETERSTYLEに固定されている。 //
NSArray *tky2jgdFromArray(NSInteger from,NSInteger to,NSInteger area,NSArray *tkyBL,NSURL *fileURL,NSURL *geoidFileURL,NSDictionary *geoidDictionary,NSDictionary *patchJGDDic); // tky2jgdFromContents()のフロントエンド //
NSString *versionOfParameterFile(NSURL *fullpath);
struct CONVERTDATA threeParameter(NSInteger from,NSInteger to,NSInteger area,NSInteger style,double br,double lr,double hh,NSURL *geoidFileURL,NSDictionary *geoidDictionary); // hhはジオイド面からの高さ(標高) //

NSString *angleForm(ASDegreeUnit radianOrDegree, double value, NSString *form); // valueで指定されたradianOrDegree単位の数値を、60進法で表現される数値に分解し、formで与えられた書式に整形した文字列を返す。radianOrDegreeはASDegreeUnitwで指定されたうちのいずれか。formatはprintf()で使われる書式指定そのままを指定する。度・分の所はint(d,i)にしなければならない。秒の所はdouble(f,e,E,g,G)にしなければならない。分・秒の数値は常に正の値を返す。数値指定は必ず3か所でなければならない。度の数値書式設定の前に数値文字"1"が渡される可能性のある文字列(例えば"NO.1"というような文字列)は指定できない。例えば@"角度=%+6d度%2d分%9.6f秒\n",あるいは@"%-10d%20d%30.0f"というようにする。formatがnil又は空文字列のときはデフォルトの書式が設定される。デフォルトは「-123°04'05"」であるが、プロポーショナルな漢字を使うのでC関数で%12s(最小指定数)と指定しても表示される幅は%11s分の幅しか取らないので注意すること。 //
double makeTriangle(NSInteger kind,struct XYZDATA *points,NSUInteger pointCount,NSInteger r,NSUInteger bottom0Index,NSUInteger bottom1Index,NSUInteger totalCount,NSMutableArray *returnArray); // 再帰型。 kind:0=三斜 1=三辺法 returnArray:最初に空配列を渡す //

// これ以降は、traditional-Cでコンパイルできる //
// slib.h //
#ifndef __APPLE__
typedef long int NSInteger;
typedef unsigned long int NSUInteger;
typedef float CGFloat;
#define NSNotFound 2147483647
#endif
double atan3(double y,double x); // y/x のアークタンジェントを計算する。０から２ＰＩまでのラジアンを返す。 //
double ASRound(NSInteger p,double x); // double型のxを精度pで四捨五入又は切り捨てしてその結果を返す。pが負数のとき切り捨て。pが-100以下のときは整数で切り捨て。//
NSUInteger secondMeshcode(double b,double l); // 2次メッシュとは25,000分の1地形図の図郭を表す。緯度が40'上がる毎に100上る。緯度を0.40'で割って小数以下を切り捨てしたものが1次メッシュの上2桁。経度が1度上がる毎に1上る。経度から100を引いて小数以下を切り捨てしたものが1次メッシュの下2桁。1次メッシュの原点からの緯度の差を0.40'/8=0.05'で割って切り捨てると2次メッシュの上1桁。1次メッシュの原点からの経度の差を1度/8=0.07'30"で割って切り捨てると2次メッシュの下1桁。b,lはラジアン。%04lu%02lu //
NSUInteger thirdMeshcode(double b,double l); // 3次メッシュとは2,500分の1地形図の図郭を表す。2次メッシュの原点からの緯度の差を0.05'/10=0.00'30"で割って切り捨てると2次メッシュの上1桁。2次メッシュの原点からの経度の差を0.07'30"/10=0.00'45"で割って切り捨てると2次メッシュの下1桁。b,lはラジアン。3次メッシュの下位2桁は00~99までの連続した10進数。%04lu%02lu%02lu */
struct XYZDATA getSecondMeshOrigin(NSUInteger meshcode);
struct XYZDATA getThirdMeshOrigin(NSUInteger meshcode);
double dtor(double x); // DDD.MMSSSSSS表現のxをラジアンに変換 //
double rtod(double x); // ラジアンxをDDD.MMSSSSSS表現に変換 //
struct XYZDATA crosspoint(struct XYZDATA a0,struct XYZDATA a1,struct XYZDATA b0,struct XYZDATA b1); // 4点交点。平行のときx,y,zともにMAXFLOATを返す。 //
BOOL iscross(struct XYZDATA p,struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3);
struct TRIANGLE gettriangle(struct XYZDATA *points);
struct XYZDATA perpendicular(struct XYZDATA bottom0,struct XYZDATA bottom1,struct XYZDATA top); // topからbottom0,bottom1線分への垂線の足。エラーのときx,y,zともにMAXFLOATを返す。 //
struct XYZDATA threeponea(struct XYZDATA bottom0,struct XYZDATA bottom1,struct XYZDATA top,double radian); // topから方向角radianで引いた線分ととbottom0,bottom1線分との交点。エラーのときx,y,zともにMAXFLOATを返す。 //
struct XYZDATA twoptwoa(struct XYZDATA p0,struct XYZDATA p1,double t0,double t1); // p0から方向角t0で引いた線分と、p1から方向角t1で引いた線分との交点。エラーのときx,y,zともにMAXFLOATを返す。 //
double twoptwoc(struct XYZDATA p0,struct XYZDATA p1,double r0,double r1,struct XYZDATA *result); // 中心点p0 半径r0の円と、中心点p1 半径r1の円との交点。resultは2個以上の要素を割り当てたstruct XYZDATAへのポインタ。弦の長さを返す。座標値構造体resultへ交点座標値を格納する。エラーのときMAXFLOATを返す。 //
double twoponec(struct XYZDATA p0,double r,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA *result); // 中心点p0 半径rの円と、点p1と点p2とを結ぶ直線との交点。resultは2個以上の要素を割り当てたstruct XYZDATAへのポインタ。弦の長さを返す。座標値構造体resultへ交点座標値を格納する。エラーのときMAXFLOATを返す。 //
double offset(struct XYZDATA p0,struct XYZDATA p1,double s,double h,struct XYZDATA *result); // オフセット計算。p0,p1線分上のp0からsの距離にある点resultの第2要素と、その点から垂直方向へhの距離にある点resultの第1要素とを求める。p1からresultの第2要素までの距離を返す。 //
struct XYZDATA twoponel(struct XYZDATA p0,struct XYZDATA p1,double s); // p0,p1線分上のp0から距離sにある点の座標値構造体を返す。エラーのときMAXFLOATを返す。 //
double widthcross(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,double w,struct XYZDATA *result); // 幅w指定による平行線分割。resultは2個以上の要素を割り当てたstruct XYZDATAへのポインタ。2個のresult間の距離を返す。エラーのときMAXFLOATを返す。 //
double cornerlm(struct XYZDATA top,struct XYZDATA p0,struct XYZDATA p1,double w0,double w1,double s,BOOL m,struct XYZDATA *result); // 隅切計算。sは隅切剪除長または隅切長。隅切長を与えるときはmをYESとする。resultは2個以上の要素を割り当てたstruct XYZDATAへのポインタ。隅切面積を返す。エラーのときMAXFLOATを返す。 //
struct XYZDATA fourpp(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,double w0,double w1); // 幅取り交点。エラーのときx,y,zともにMAXFLOATを返す。 //
struct XYZDATA pointax(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,double area2); // p0は固定点。p1は移動する側の固定点。p2は方向点。area2はp1から途中の屈曲点を経てp0を通ってp1で閉じる部分の倍面積。p1,p2線分上の点の座標値構造体を返す。エラーのときx,y,zともにMAXFLOATを返す。 //
double directionax(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,double phi,double area2,struct XYZDATA *result); // 定方向角を持つ平行線による整正。area2は倍面積。 //
double paradiv(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,double fixArea2,double area2,struct XYZDATA *result); // p0,p2線分に平行な線分で倍面積fixArea2になるように分割。area2はp0からp2までの途中の点によって囲まれた部分の余分な部分の倍面積。 //
double perpendiv(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,double fixArea2,double area2,BOOL upBase, struct XYZDATA *result); // p0,p1線分またはp2,p3線分に直角な方向で倍面積fixArea2になるように分割。p0,p1線分に直角な場合はupBaseはYES。area2はp0からp2までの途中の点によって囲まれた部分の余分な部分の倍面積。 //
double directiondiv(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,double fixArea2,double area2,double phi, struct XYZDATA *result); // 定方向角を持つ平行線により倍面積fixArea2になるように分割。area2はp0からp2までの途中の点によって囲まれた部分の余分な部分の倍面積。 //
double pointdiv(struct XYZDATA p0,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,double fixArea2,double area2,double dist,BOOL upBase, struct XYZDATA *result); // 定点を通る放射線による分割。fixArea2,area2ともに倍面積。 //
struct XYZDATA twosidesinterior(struct XYZDATA p0,struct XYZDATA p1,double e,double phi); // 2辺夾角により、偏心点の座標値構造体を返す。 //
double mutualeccentric(struct XYZDATA p0,struct XYZDATA p1,double e0,double e1,double phi0,double phi1,struct XYZDATA *result); // 相互偏心点2点の座標値をresultへ返す。偏心点間の平面距離を関数の戻り値として返す。国土交通省「計算式集」2.2.3におけるα1はphi0,α2はphi1である。e1はe0,e2はe1である。P1がp0,P2がp1に該当する。xは時計回りの角度である。国土交通省「計算式集」では反時計回りの角度が示されている。 //
double insidecheck(struct XYZDATA *points,NSUInteger count,NSUInteger firstindex,NSUInteger secondindex); // pointsで囲まれた区画の中にfirstindexからsecondindexで区切られた区画が含まれているときは正の距離が返る。含まれていない時は負の距離が返る。 //
double directionconvert(double xi,double yi,double xk,double yk,double m,double n,NSInteger areaCode); // 国土交通省「作業規程の準則」「計算式集」2.4.1(1)方向角の変換による。iからkへの基準面上の観測方向角にこの関数の値を加えると、iからkへの平面直角座標上の観測方向角になる。引数は m:長半径 n:短半径。戻り値はラジアン単位。 //
double strictscale(double y1,double y2,double m,double n,NSInteger areaCode); // Y座標y1とY座標y2の値が異なるときは、国土交通省「作業規程の準則」「計算式集」2.4.1(2)距離の変換 を使うので平面距離や基準面上の距離を計算するときに使う。このときの引数は m:長半径 n:短半径。y1とy2が同じときはmとnは長半径と短半径ではないので、使いにくい。xytobl()から使われることを想定している。 //
NSInteger areacenter(NSInteger n,double *phi0,double *l0); // n は日本平面直角座標系の座標系番号を整数値で与える。1995年現在19まである。phi0,l0はそれぞれ、原点の緯度と経度とをDMSで返す。nが0のときは、与えられたphi0,l0にもっとも近くにある座標原点から座標系番号を推定してその番号を返す。 //
NSUInteger radiusofsystem(NSInteger systemtag); // 測地系のタグによって準拠楕円体のタグを決定する。エラーのときNSNotFoundが返る。 //
struct XYZDATA constantsofglobe(NSUInteger spheretag); // 準拠楕円体のタグによって楕円体の定数を決定する。.x:長半径 .y:短半径 .z:扁平率の逆数 を返す。spheretagがNSNotFoundならば.xと.yにAPPLOXIMATERADIUSOFGLOBE, .zにMAXFLOATが返される。 //
struct CONVERTPARAMETER convertParameter(NSInteger style,NSInteger from,NSInteger to); // styleに与える値は、0:「国土地理院数値地図5kmメッシュ(ジオイド高)」 1:「建設省公共測量作業規程」1996年以前 2:「建設省公共測量作業規程」1996年版 3:「国土地理院」測地成果2000 //
double *meridianCoefficients(NSInteger system); // 緯度を与えて赤道からの子午線弧長を求める計算のための9つの係数を返す。 //
double meridianArc(double *c,double a,double e2,double phi); // 赤道から緯度phiラジアンまでの子午線弧長を返す。xは9つの係数。aは楕円体長半径。e2は第1離心率の自乗。 //
struct BLDATA xytobl(NSInteger system,NSInteger n,double x,double y); // ベッセル・GRS80の両方とも適用できる。systemは測地系番号 nは座標系番号 x,y は日本平面直角座標系の座標値。.bd.br:緯度 .ld.lr:経度 .nd.nr:子午線収差角 .m:縮尺係数を格納した構造体を返す。ndとnr の符号は、(x,y) の位置が当該座標系原点より東にあるときは負、西は正とする。正常に変換できた場合には.mに正の数値が返る。エラー発生の場合には負の数を返す。ラジアンで計算して最後にＤＭＳ形式に変換するのでラジアン形式データの方が精度が高い。 //
struct BLDATA xytobl_koukyou(NSInteger system,NSInteger n,double x,double y); // systemは測地系番号 nは座標系番号 x,y は日本平面直角座標系の座標値。.bd.br:緯度 .ld.lr:経度 .nd.nr:子午線収差角 .m:縮尺係数を格納した構造体を返す。ndとnr の符号は、(x,y) の位置が当該座標系原点より東にあるときは負、西は正とする。正常に変換できた場合には.mに正の数値が返る。エラー発生の場合には負の数を返す。国土交通省「公共測量作業規程」(2002年)の計算式に準拠。ラジアンで計算して最後にＤＭＳ形式に変換するのでラジアン形式データの方が精度が高い。 //
struct XYHDATA bltoxy(NSInteger system,NSInteger num,double br,double lr); // systemは測地系のタグ。num は日本平面直角座標系の座標系番号を整数値で与える。br,lr は緯度、経度(ラジアン)。座標値構造体を返す。.x:X座標値 .y:Y座標値 .n:子午線収差角(ラジアン) .m:縮尺係数 .h:意味が無い値。 //
struct XYZDATA bltoxy_kokyou(NSInteger system,NSInteger num,double br,double lr); // systemは測地系のタグ。num は日本平面直角座標系の座標系番号を整数値で与える。br,lr は緯度、経度(ラジアン)。座標値構造体を返す。.x:X座標値 .y:Y座標値 .z:子午線収差角(ラジアン)。国土交通省「基準点測量作業規程」(2002年)の計算式に準拠。 //
struct XYZDATA blToThreeDCoordinate(NSUInteger num,double br,double lr,double h); // 緯度b,経度l,楕円体からの高さhを直交座標に変換する。num は準拠楕円体の番号。1984:WGS-84系 1841:Bessel 1980:GRS80。b,lはDMS。hは準拠楕円体からの高さ(ジオイドからの高さではない。即ち標高ではない。)。point->z は Z軸の座標値(高さではない)。建設省「基準点測量作業規程」(1996年)の計算式に準拠。我が家の位置はX=-29206.3497m,Y=-52708.2444m 標高745.9mくらいなので、B=35.44186,L=137.54510,h=789.283(DMS,GWS-80)くらいになる。またはB=35.44071,L=137.55020,h=744.8(DMS,TokyoDatum)。GPSの標準フォーマットでは、ORD=POI/tex=佐藤昭/ido=035'44'18'6/kei=137'54'51'0 と書くらしい。 //
struct BLDATA threeDCoordinateToBL(NSUInteger num,double x,double y,double z); // num で指定された準拠楕円体の直交座標を緯度,経度,高さに変換する。 三次元座標で捕らえているので、zの値は、Z軸の座標値(高さではない)となる。 blsp.m に準拠楕円体からの高さを返す(標高ではない)。blsp.ndに準拠楕円体の長半径,blsp.nrに扁平率の逆数を返す。 //
struct BLDATA systemConvert(NSInteger style,NSInteger num0,NSInteger num1,double br,double lr,double sh); // 日本測地学会「新訂版ＧＰＳ」177ページの座標変換の公式による。styleはshiftThreeD()と同じ意味。num0,num1 は測地系の番号。1984:WGS-84系 1841:TokyoDatum 1994:ITRF94 2008:ITRF2008 2014:ITRF2014。ITRF2008とITRF2014については資料が無いためITRF94と同じ扱いにしている。shはnum0での準拠楕円体からの高さ(ジオイドからの高さではない。即ち標高ではない。)。num0からnum1への変換をする。 //
struct XYZDATA shiftThreeD(NSInteger style,NSInteger num0,NSInteger num1,double x,double y,double z); // 測地系番号num0からnum1への平行移動変換。 //
NSInteger getvector(NSInteger system,NSInteger num,struct BLDATA bldat0,struct BLDATA bldat1,struct XYZDATA *dpoint); // systemは測地系のタグ。1841でなければならない。GPS相対測位のための関数。numは日本平面直角座標系のZone NO.。bldat0 からbldat1への局所測地楕円体上でのベクトルを返す。bldat0とbldat1とは、ベッセル楕円体・東京測地系(Tokyo Datum)上のデータでなければならない。Tokyo Datumでない場合には、systemConvert()関数により変換をさせてからbldatを与える。bldat.mには局所測地楕円体からの高さ(ジオイドからの高さ・標高ではない)を与える。 //
NSInteger leastsqr(double *a,double *b,NSInteger l,NSInteger m,double **x); // 最小自乗解。x に解ベクトルが入る。X = (転置A * A)逆行列 * 転置A * B。 //
NSInteger mat_add(double *a,double *b,NSInteger m,NSInteger n,double **c);
NSInteger mat_inv(double *a,NSInteger l,NSInteger m,double **im); // LU分解法による。「インフォメーション」1983.VOL2.No.3 ５月号 p.141。ピボッティングの操作については啓学出版「科学技術計算サブルーチンライブリ」p.141。正方行列 m*m の逆行列。a[i][j] : i行,j列 の要素。l : a の列数。m : 演算対象となる行列数。エラーのとき-1,正常終了のとき0が返る。 //
NSInteger mat_mult(double *a,double *b,NSInteger m,NSInteger n,NSInteger o,double **c); // m行,n列の行列[c] = [a] * [b]。m : a の行数。n : b の列数。o : a の列数 & b の行数。 //
double mat_value(double *a,NSInteger m,NSInteger n); // m行,n列の行列aの値を返す。線積の計算などに使える。 //
double mat_sigma(double *a,NSInteger m); // m * m 行列式aの値を返す。 //
NSInteger mat_sub(double *a,double *b,NSInteger m,NSInteger n,double **c); // [c] = [a] - [b] //
NSInteger mat_trn(double *a,NSInteger m,NSInteger n,double **b); // aの転置行列を求めてbに格納する。b[j][i] = a[i][j]。m : a の行数。n : a の列数。 //
double pnorm(double qn); // 標準正規分布の累積確率Q(u)からuパーセント点)を戸田の近似式により求める。戻り値はパーセント点。 //
double pt(double q,NSUInteger nu); // t分布の両側確率に対するパーセント点を山内の近似等の方法により求める。q:t分布の両側確率で範囲は1.0e-5から1.0まで。nu:自由度の値で1以上。戻り値はパーセント点。 //
double pchi(double qc,NSUInteger nu); // χ2分布の上側確率に対するパーセント点をCornish-Fisher等の方法により求める。qc:上側確率の値で範囲は0.0以上1.0以下。nu:自由度の値。戻り値はパーセント点。 //
double mltnreg1d(double *a,double *b,double *x,NSInteger l,NSInteger m); // エラーが発生すると-1.0から-4.0までの負の数が返る。 //
double regiter1d(double *a,double *b,NSInteger l,NSInteger m,double **x); // a : 係数行列。b : 定数ベクトル。x : 解ベクトル。l : 変数の数。m : 方程式の数。戻り値 : あてはまり誤差の平均二乗誤差。エラーが発生すると-1.0から-6.0までの負の数または不定の負の数が返る。 //
struct AFFINE affine_conv(NSInteger pointnum,double *xr,double *yr,double *xh,double *yh,double **dx,double **dy); // アフィン変換用のregiter1d()へのフロントエンドである。xr,yrは変換前の座標値の羅列。xh,yhは変換されるべき座標値の羅列。pointnumは3以上でなければならない。ここではチェックしないので呼び出し側でチェックする。dx,dyには変換結果の誤差が格納される。dx,dyは呼び出し側でmalloc(pointnum*sizeof(double)しなければならない。残差情報が必要ない場合にはdx,dyにNULLポインタを渡す。呼び出しは、struct AFFINE affine; affine=affine_conv(pointnum,xr,yr,xh,yh,dx,dy); でここのtempがaffineにコピーされる。エラー発生のとき、AFFINE構造体のaffine.sd に負の数が返される。sd:残差の標準偏差。xh = a * xr + b * yr + c; yh = d * xr + e * yr + f;  で新座標xh,yhが求められる。 //
struct HERMERT hermert_conv(NSInteger pointnum,double *xr,double *yr,double *xh,double *yh,double **dx,double **dy); // ヘルマート変換用のregiter1d()へのフロントエンドである。pointnumは重要な要素である。呼び出し側で正確な数値を送る必要が有る。xr,yrは変換前の座標値の羅列。xh,yhは変換されるべき座標値の羅列。dx,dyには変換結果の誤差が格納される。dx,dyは呼び出し側でmalloc(pointnum*sizeof(double)しなければならない。残差情報が必要ない場合にはdx,dyにNULLポインタを渡す。呼び出しは、struct HERMERT hermert; hermert=hermert_conv(pointnum,xr,yr,xh,yh,dx,dy); でここのtempがhermertにコピーされる。エラー発生のとき、HERMERT構造体のhermert.scaleに 0.0 temp.sd に負の数が返される。座標変換するには、mcos,msin,c,dの4つのデータで行う。xh = mcos * xr + msin * yr + c; yh = mcos * yr - msin * xr + d; で新座標xh,yhが求められる。sd:残差の標準偏差 scale:伸縮率 t:回転角のラジアン //
NSInteger doublecmp(double *a,double *b);
double bilinear(struct XYZDATA *p,struct XYZDATA p1,struct XYZDATA p2,struct XYZDATA p3,struct XYZDATA p4); // p1,p2,p3,p4がx,yで仕切られたグリッド上に有る時、その中間点のpのzを補間して求める。p:求点 p1:左下のグリッド上の点 p2:右下のグリッド上の点 p3:左上のグリッド上の点 p4:右上のグリッド上の点。 //
double interpol1(double u1,double u2,double u3,double u4,double X0to1,double Y0to1); // 国土地理院「TKY2JGD」に記載されている方法。 //

@end
