//
//  ASImageViewCell.h
//  ASImageView
//
//  Created by 佐藤 昭 on 平成 21/02/11.
//  Copyright 2009 SatoAkira. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#define USESVG 1
#ifdef USESVG
#import "ASWebImageRep.h"
#endif


@interface ASImageViewCell : NSActionCell

- (NSImageRep *)imageRep; // NSPDFImageRepの場合、imageReps countを見てもページ数がわからないので必ずこれをフェッチすること。NSPDFImageRepでない場合はcurrentPageに対応するNSImageRepを返す。 //
- (void)setImageWithArray:(NSArray *)anArray; // setImage:の代わり //
- (void)setImageRep:(NSImageRep *)imageRep; // setImage:の代わり //
- (NSArray *)imageReps;
- (NSDictionary *)generalProperties; // NSBitmapImageRepの一般的な属性値の取得。NSPDFImageRepの場合にはPDFDocumentのdocumentAttributes:のフロントエンド。 //
- (NSDictionary *)metadataFromSource:(id)source;
- (NSDictionary *)CGImagePropertyInMetadata:(NSDictionary *)metadata key:(NSString *)property; // NSBitmapImageRepの場合のkeyに対応する属性を取得する。keyは(NSString *)kCGImageProperty...Dictionary //
- (NSColor *)backgroundColor;
- (void)setBackgroundColor:(NSColor *)aColor;
- (BOOL)useBackgroundColor;
- (void)setUseBackgroundColor:(BOOL)flag;
- (CGFloat)delta;
- (void)setDelta:(CGFloat)aValue;
- (NSCompositingOperation)compositingOperation;
- (void)setCompositingOperation:(NSCompositingOperation)aValue;
- (NSImageAlignment)imageAlignment;
- (void)setImageAlignment:(NSImageAlignment)aValue;
- (NSImageFrameStyle)imageFrameStyle;
- (void)setImageFrameStyle:(NSImageFrameStyle)aValue;
- (NSImageScaling)imageScaling;
- (void)setImageScaling:(NSImageScaling)aValue;
- (NSInteger)currentPage;
- (void)setCurrentPage:(NSInteger)aValue;
- (NSSize)originalSize;
- (BOOL)canUseFraction;
- (BOOL)isFlipped;

@end

extern NSString *ASImageViewImageRepsKey;
extern NSString *ASImageViewCurrentPageKey;
extern CGFloat ASImageViewDefaultFraction;
extern NSString *ASImageViewFractionKey;
extern NSString *ASImageViewCanUseFractionKey;
extern NSCompositingOperation ASImageViewDefaultCompositeOperation;
extern NSString *ASImageViewCompositingOperationKey;
extern NSString *ASImageViewImageScalingKey;
extern NSString *ASImageViewImageFrameStyleKey;
extern NSString *ASImageViewImageAlignmentKey;
extern NSString *ASImageViewBackgroundColorKey;
extern NSString *ASImageViewUseBackgroundColorKey;
