//
//  ASTextLibrary.h
//  ASTextLibrary
//
//  Created by 佐藤昭 on 2020/05/20.
//  Copyright © 2020 SatoAkira. All rights reserved.
//

#import <Cocoa/Cocoa.h>

//! Project version number for ASTextLibrary.
FOUNDATION_EXPORT double ASTextLibraryVersionNumber;

//! Project version string for ASTextLibrary.
FOUNDATION_EXPORT const unsigned char ASTextLibraryVersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <ASTextLibrary/PublicHeader.h>


@interface ASTextLibrary : NSObject

#define FLDATEDISTANTPAST @"201-01-01"
#define DISTANTFUTURE @"4001-01-01"
// 環境設定に関わり無く4001-01-01となる。[[NSDate distantFuture] descriptionWithCalendarFormat:@"%Y-%m-%d" timeZone:nil locale:nil] //

+ (NSDictionary *)tableBlockDictionary:(NSString *)formatString tableFont:(NSFont *)font; // \a:NSLeftTabStopType \v:NSRightTabStopType \b:NSCenterTabStopTypeは幅の後ろに付ける。 \e:NSRightTabStopTypeまたはNSCenterTabStopTypeより前に付けて表の縦線の位置決めに使う。 \r,\n,\tは識別記号に使えない。使えない理由はこれらの文字によって文字の配置が編集されてしまうからである。 //
// for example.[self tableBlockDictionary:@"\e999\v \aSSS \e-999999.9999\v \e-999999.9999\v \e-9999.9999\v \e-9999999999.99999999\v \e9999.9999\v" tableFont:font] //
+ (NSAttributedString *)tableCellAttributedString:(NSString *)string attributes:(NSMutableDictionary *)attrs style:(NSInteger)selectedRow underline:(BOOL)underlineToggle at:(NSUInteger *)row; // stringの先頭は必ず\tから始めること。そうでない場合は最初に現れる\tから解析を始める。\t区切り専用である。末尾に\nはあっても無くても良い。途中に\nがあるとrowを進めることなくその駒の中で改行する。表形式のとき標準のattributes以外に必要なものが沢山ある。tableBlockDictionary:tableFont:によって必要なものが作られるので、addEntries:などを使ってセットすれば良い。 //
CGFloat pointLength(NSString *str,NSFont *font);
NSArray *leftTabStops(CGFloat *t,NSUInteger count,CGFloat tabUnit);
NSArray *multiTabStops(NSTextTabType *types,CGFloat *t,NSUInteger count,CGFloat tabUnit);
NSNumber *kerning(CGFloat width,NSString *string,NSFont *aFont);
NSAttributedString *kerningAttrStr(BOOL tabFlag,CGFloat width,NSString *aString,NSDictionary *attributes,BOOL lfFlag); // kerningが必要だということは大概の場合は位置合わせをすることを意味するのでtabFlagがYESのとき、タブを自動的に付ける。 //
NSBezierPath *underlinePath(NSPoint start,CGFloat length,CGFloat width);
NSString *strntrim(NSString *aString,NSInteger cutLength,BOOL cFlag); // cutLengthが0以下のとき、長さの指定が無いものとする。cFlagは無視する。もはやC言語の長さに合わせる必要は無くなった。aStringとは別アドレスのNSStringが返る。 //
NSString *fldate(NSString *dateString);
// 不完全に日付が並べられている文字列dateStringを10桁の定型書式に変換して、その文字列を返す。 //
// 日のみの場合、あるいは月日のみの場合にはシステム時刻から年月等を得てそれを加える。 //
// dateStringが空文字(NULLではない)の場合には、システム時刻の日付となる。 //
// "西暦年(4桁)-月(2桁)-日(2桁)"の書式で返す。引数dateStringも右づめでこの並びであることが必要である。 //
// 桁数が不足している場合には、左の方が省略されたものとみなす。 //
// 昔の米国式の"月/日/年"という並びには対応しない。 //
// 文字列dateStringのなかで年号が直接指定されている場合 //
//     1年から79年は2000年を加える。"79-12-31"は"2079-12-31"になる。 //
//     80年から200年は1900年を加える。"1000101"は"2000-01-01"になる。 //
//     201年から9999年はそのまま。"-9999*04*20"は"9999-04-20"になる。 //
//     従って、紀元前から西暦100年の間は不対応。 //
// 2000年対応。 //
// 使い方の例は以下 //
// Objective-C の場合 //
//	[textField setStringValue:fldate([sender stringValue])]; //
NSString *eraDate(NSString *aString); // 使い途無し。"年"とかの文字を取得する方法が無いので汎用にならない。 //
CGFloat ToolbarHeightForWindow(NSWindow *window);
/* NSString *UTI(NSString *path); */ // macOS 12.0からは使いにくくなったので削除 //

@end

extern NSString *TabStopsKey;
extern NSString *PointLengthKey;
extern NSString *AlignmentsKey;
extern NSString *XEdgePaddingKey;
extern NSString *LineFragmentPaddingKey;
extern NSString *TextTableKey;
extern NSString *TableStopsKey;
